/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.table;

import io.crate.common.collections.MapBuilder;
import io.crate.common.collections.Sets;
import io.crate.exceptions.OperationOnInaccessibleRelationException;
import io.crate.metadata.RelationInfo;
import io.crate.replication.logical.LogicalReplicationSettings;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Settings;

public enum Operation {
    READ("READ"),
    UPDATE("UPDATE"),
    INSERT("INSERT"),
    DELETE("DELETE"),
    DROP("DROP"),
    ALTER("ALTER"),
    ALTER_SET("ALTER SET"),
    ALTER_BLOCKS("ALTER"),
    ALTER_OPEN("ALTER OPEN"),
    ALTER_CLOSE("ALTER CLOSE"),
    ALTER_TABLE_RENAME("ALTER RENAME"),
    ALTER_REROUTE("ALTER REROUTE"),
    REFRESH("REFRESH"),
    SHOW_CREATE("SHOW CREATE"),
    OPTIMIZE("OPTIMIZE"),
    COPY_TO("COPY TO"),
    RESTORE_SNAPSHOT("RESTORE SNAPSHOT"),
    CREATE_SNAPSHOT("CREATE SNAPSHOT"),
    CREATE_PUBLICATION("CREATE PUBLICATION");

    public static final EnumSet<Operation> ALL;
    public static final EnumSet<Operation> SYS_READ_ONLY;
    public static final EnumSet<Operation> READ_ONLY;
    public static final EnumSet<Operation> CLOSED_OPERATIONS;
    public static final EnumSet<Operation> BLOB_OPERATIONS;
    public static final EnumSet<Operation> READ_DISABLED_OPERATIONS;
    public static final EnumSet<Operation> WRITE_DISABLED_OPERATIONS;
    public static final EnumSet<Operation> METADATA_DISABLED_OPERATIONS;
    public static final EnumSet<Operation> SUBSCRIBED_IN_LOGICAL_REPLICATION;
    public static final EnumSet<Operation> PUBLISHED_IN_LOGICAL_REPLICATION;
    private final String representation;
    private static final Map<String, EnumSet<Operation>> BLOCK_SETTING_TO_OPERATIONS_MAP;

    private Operation(String representation) {
        this.representation = representation;
    }

    public static EnumSet<Operation> buildFromIndexSettingsAndState(Settings settings, IndexMetadata.State state, boolean isPublished) {
        if (state == IndexMetadata.State.CLOSE) {
            return CLOSED_OPERATIONS;
        }
        Set<Operation> operations = ALL;
        boolean isSubscribed = Operation.isReplicated(settings);
        if (isSubscribed && isPublished) {
            operations = SUBSCRIBED_IN_LOGICAL_REPLICATION;
        } else if (isSubscribed) {
            operations = SUBSCRIBED_IN_LOGICAL_REPLICATION;
        } else if (isPublished) {
            operations = PUBLISHED_IN_LOGICAL_REPLICATION;
        }
        for (Map.Entry<String, EnumSet<Operation>> entry : BLOCK_SETTING_TO_OPERATIONS_MAP.entrySet()) {
            if (!settings.getAsBoolean(entry.getKey(), false).booleanValue()) continue;
            operations = Sets.intersection((Set)entry.getValue(), operations);
        }
        return EnumSet.copyOf(operations);
    }

    public static boolean isReplicated(Settings settings) {
        String subscriptionName = LogicalReplicationSettings.REPLICATION_SUBSCRIPTION_NAME.get(settings);
        return subscriptionName != null && !subscriptionName.isEmpty();
    }

    public static void blockedRaiseException(RelationInfo relationInfo, Operation operation) {
        if (!relationInfo.supportedOperations().contains((Object)operation)) {
            String exceptionMessage = relationInfo.supportedOperations().equals(CLOSED_OPERATIONS) ? "The relation \"%s\" doesn't support or allow %s operations, as it is currently closed." : (relationInfo.supportedOperations().equals(SUBSCRIBED_IN_LOGICAL_REPLICATION) ? "The relation \"%s\" doesn't allow %s operations, because it is included in a logical replication subscription." : (relationInfo.supportedOperations().equals(PUBLISHED_IN_LOGICAL_REPLICATION) ? "The relation \"%s\" doesn't allow %s operations, because it is included in a logical replication publication." : "The relation \"%s\" doesn't support or allow %s operations"));
            throw new OperationOnInaccessibleRelationException(relationInfo.ident(), String.format(Locale.ENGLISH, exceptionMessage, new Object[]{relationInfo.ident().fqn(), operation}));
        }
    }

    public String toString() {
        return this.representation;
    }

    static {
        ALL = EnumSet.allOf(Operation.class);
        SYS_READ_ONLY = EnumSet.of(READ);
        READ_ONLY = EnumSet.of(READ, ALTER_BLOCKS);
        CLOSED_OPERATIONS = EnumSet.of(ALTER_OPEN, new Operation[]{ALTER_CLOSE, ALTER_TABLE_RENAME, ALTER, ALTER_SET, ALTER_BLOCKS});
        BLOB_OPERATIONS = EnumSet.of(READ, new Operation[]{OPTIMIZE, ALTER, ALTER_SET, ALTER_BLOCKS, ALTER_REROUTE, DROP});
        READ_DISABLED_OPERATIONS = EnumSet.of(UPDATE, new Operation[]{INSERT, DELETE, DROP, ALTER, ALTER_SET, ALTER_OPEN, ALTER_CLOSE, ALTER_REROUTE, ALTER_BLOCKS, REFRESH, OPTIMIZE});
        WRITE_DISABLED_OPERATIONS = EnumSet.of(READ, new Operation[]{ALTER, ALTER_SET, ALTER_OPEN, ALTER_CLOSE, ALTER_BLOCKS, ALTER_REROUTE, SHOW_CREATE, REFRESH, OPTIMIZE, COPY_TO, CREATE_SNAPSHOT});
        METADATA_DISABLED_OPERATIONS = EnumSet.of(READ, new Operation[]{UPDATE, INSERT, DELETE, ALTER_BLOCKS, ALTER_OPEN, ALTER_CLOSE, ALTER_REROUTE, REFRESH, SHOW_CREATE, OPTIMIZE});
        SUBSCRIBED_IN_LOGICAL_REPLICATION = EnumSet.of(READ, new Operation[]{ALTER_SET, ALTER_BLOCKS, ALTER_REROUTE, OPTIMIZE, REFRESH, COPY_TO, SHOW_CREATE});
        PUBLISHED_IN_LOGICAL_REPLICATION = EnumSet.of(READ, new Operation[]{UPDATE, INSERT, DELETE, DROP, ALTER, ALTER_SET, ALTER_BLOCKS, ALTER_CLOSE, ALTER_REROUTE, REFRESH, SHOW_CREATE, COPY_TO, OPTIMIZE, RESTORE_SNAPSHOT, CREATE_SNAPSHOT});
        BLOCK_SETTING_TO_OPERATIONS_MAP = MapBuilder.newMapBuilder().put((Object)"index.blocks.read_only", READ_ONLY).put((Object)"index.blocks.read", READ_DISABLED_OPERATIONS).put((Object)"index.blocks.write", WRITE_DISABLED_OPERATIONS).put((Object)"index.blocks.metadata", METADATA_DISABLED_OPERATIONS).map();
    }
}

