/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.dml.BulkResponse;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface Plan {
    public StatementType type();

    public void executeOrFail(DependencyCarrier var1, PlannerContext var2, RowConsumer var3, Row var4, SubQueryResults var5) throws Exception;

    default public void execute(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        try {
            this.executeOrFail(dependencies, plannerContext, consumer, params, subQueryResults);
        }
        catch (Throwable t) {
            consumer.accept(null, t);
        }
    }

    default public CompletableFuture<BulkResponse> executeBulk(DependencyCarrier executor, PlannerContext plannerContext, List<Row> bulkParams, SubQueryResults subQueryResults) {
        throw new UnsupportedOperationException("Bulk operation not supported for " + this.getClass().getSimpleName());
    }

    public static enum StatementType {
        INSERT,
        SELECT,
        UPDATE,
        DELETE,
        COPY,
        DDL,
        MANAGEMENT,
        UNDEFINED;

    }
}

