/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.AnalyzedStatement;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.planner.operators.CorrelatedJoin;
import io.crate.planner.operators.LogicalPlan;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class SubqueryPlanner {
    private final Function<SelectSymbol, LogicalPlan> planSubSelects;

    public SubqueryPlanner(Function<SelectSymbol, LogicalPlan> planSubSelects) {
        this.planSubSelects = planSubSelects;
    }

    public SubQueries planSubQueries(AnalyzedStatement statement) {
        SubQueries subQueries = new SubQueries(new LinkedHashMap<LogicalPlan, SelectSymbol>(), new LinkedHashMap<SelectSymbol, LogicalPlan>());
        statement.visitSymbols(tree -> tree.visit(SelectSymbol.class, selectSymbol -> this.planSubquery((SelectSymbol)selectSymbol, subQueries)));
        return subQueries;
    }

    private void planSubquery(SelectSymbol selectSymbol, SubQueries subQueries) {
        if (selectSymbol.isCorrelated()) {
            if (!subQueries.correlated.containsKey(selectSymbol)) {
                LogicalPlan subPlan = this.planSubSelects.apply(selectSymbol);
                subQueries.correlated.put(selectSymbol, subPlan);
            }
        } else {
            LogicalPlan subPlan = this.planSubSelects.apply(selectSymbol);
            subQueries.uncorrelated.put(subPlan, selectSymbol);
        }
    }

    public record SubQueries(Map<LogicalPlan, SelectSymbol> uncorrelated, Map<SelectSymbol, LogicalPlan> correlated) {
        public LogicalPlan applyCorrelatedJoin(LogicalPlan source) {
            for (Map.Entry<SelectSymbol, LogicalPlan> entry : this.correlated.entrySet()) {
                LogicalPlan plannedSubQuery = entry.getValue();
                SelectSymbol subQuery = entry.getKey();
                source = new CorrelatedJoin(source, subQuery, plannedSubQuery);
            }
            return source;
        }
    }
}

