/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedCreateFunction;
import io.crate.analyze.SymbolEvaluator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.udf.CreateUserDefinedFunctionRequest;
import io.crate.expression.udf.UserDefinedFunctionMetadata;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.StringType;
import java.util.function.Function;
import org.elasticsearch.action.support.master.AcknowledgedResponse;

public class CreateFunctionPlan
implements Plan {
    private final AnalyzedCreateFunction createFunction;

    public CreateFunctionPlan(AnalyzedCreateFunction createFunction) {
        this.createFunction = createFunction;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), x, params, subQueryResults);
        UserDefinedFunctionMetadata metadata = new UserDefinedFunctionMetadata(this.createFunction.schema(), this.createFunction.name(), this.createFunction.arguments(), this.createFunction.returnType(), StringType.INSTANCE.sanitizeValue(eval.apply(this.createFunction.language())), StringType.INSTANCE.sanitizeValue(eval.apply(this.createFunction.definition())));
        CreateUserDefinedFunctionRequest request = new CreateUserDefinedFunctionRequest(metadata, this.createFunction.replace());
        OneRowActionListener<AcknowledgedResponse> listener = new OneRowActionListener<AcknowledgedResponse>(consumer, ignoredResponse -> new Row1((Object)1L));
        dependencies.createFunctionAction().execute(request).whenComplete(listener);
    }
}

