/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedDropAnalyzer;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.exceptions.AnalyzerUnknownException;
import io.crate.execution.support.OneRowActionListener;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsAction;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.VisibleForTesting;

public class DropAnalyzerPlan
implements Plan {
    private final AnalyzedDropAnalyzer dropAnalyzer;

    public DropAnalyzerPlan(AnalyzedDropAnalyzer dropAnalyzer) {
        this.dropAnalyzer = dropAnalyzer;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        ClusterUpdateSettingsRequest request = DropAnalyzerPlan.createRequest(this.dropAnalyzer.name(), dependencies.fulltextAnalyzerResolver());
        dependencies.client().execute(ClusterUpdateSettingsAction.INSTANCE, request).whenComplete(new OneRowActionListener<ClusterUpdateSettingsResponse>(consumer, ignoredResponse -> new Row1((Object)1L)));
    }

    @VisibleForTesting
    public static ClusterUpdateSettingsRequest createRequest(String analyzerName, FulltextAnalyzerResolver ftResolver) {
        if (!ftResolver.hasCustomAnalyzer(analyzerName)) {
            throw new AnalyzerUnknownException(analyzerName);
        }
        Settings.Builder builder = Settings.builder();
        builder.putNull(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingName(analyzerName));
        Settings settings = ftResolver.getCustomAnalyzer(analyzerName);
        String tokenizerName = settings.get(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(analyzerName, FulltextAnalyzerResolver.CustomType.TOKENIZER.getName()));
        if (tokenizerName != null && ftResolver.hasCustomThingy(tokenizerName, FulltextAnalyzerResolver.CustomType.TOKENIZER)) {
            builder.putNull(FulltextAnalyzerResolver.CustomType.TOKENIZER.buildSettingName(tokenizerName));
        }
        for (String tokenFilterName : settings.getAsList(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(analyzerName, FulltextAnalyzerResolver.CustomType.TOKEN_FILTER.getName()))) {
            if (!ftResolver.hasCustomThingy(tokenFilterName, FulltextAnalyzerResolver.CustomType.TOKEN_FILTER)) continue;
            builder.putNull(FulltextAnalyzerResolver.CustomType.TOKEN_FILTER.buildSettingName(tokenFilterName));
        }
        for (String charFilterName : settings.getAsList(FulltextAnalyzerResolver.CustomType.ANALYZER.buildSettingChildName(analyzerName, FulltextAnalyzerResolver.CustomType.CHAR_FILTER.getName()))) {
            if (!ftResolver.hasCustomThingy(charFilterName, FulltextAnalyzerResolver.CustomType.CHAR_FILTER)) continue;
            builder.putNull(FulltextAnalyzerResolver.CustomType.CHAR_FILTER.buildSettingName(charFilterName));
        }
        return new ClusterUpdateSettingsRequest().persistentSettings(builder.build());
    }
}

