/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedDropTable;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.ddl.tables.DropTableRequest;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.index.IndexNotFoundException;
import org.jetbrains.annotations.VisibleForTesting;

public class DropTablePlan
implements Plan {
    private static final Logger LOGGER = LogManager.getLogger(DropTablePlan.class);
    private static final Row ROW_ZERO = new Row1((Object)0L);
    private static final Row ROW_ONE = new Row1((Object)1L);
    private final AnalyzedDropTable<?> dropTable;

    public DropTablePlan(AnalyzedDropTable<?> dropTable) {
        this.dropTable = dropTable;
    }

    @VisibleForTesting
    public AnalyzedDropTable<?> dropTable() {
        return this.dropTable;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        DropTableRequest request = new DropTableRequest(this.dropTable.tableName());
        dependencies.transportDropTableAction().execute(request).whenComplete((response, err) -> {
            if (err == null) {
                if (!response.isAcknowledged() && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Dropping table {} was not acknowledged. This could lead to inconsistent state.", (Object)this.dropTable.tableName());
                }
                consumer.accept(InMemoryBatchIterator.of((Object)ROW_ONE, (Object)SentinelRow.SENTINEL), null);
            } else {
                err = SQLExceptions.unwrap(err);
                if (this.dropTable.dropIfExists() && err instanceof IndexNotFoundException) {
                    consumer.accept(InMemoryBatchIterator.of((Object)ROW_ZERO, (Object)SentinelRow.SENTINEL), null);
                } else {
                    consumer.accept(null, err);
                }
            }
        });
    }
}

