/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedRestoreSnapshot;
import io.crate.analyze.BoundRestoreSnapshot;
import io.crate.analyze.SnapshotSettings;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.SchemaUnknownException;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.VisibleForTesting;

public class RestoreSnapshotPlan
implements Plan {
    private final AnalyzedRestoreSnapshot restoreSnapshot;

    public RestoreSnapshotPlan(AnalyzedRestoreSnapshot restoreSnapshot) {
        this.restoreSnapshot = restoreSnapshot;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row parameters, SubQueryResults subQueryResults) {
        BoundRestoreSnapshot stmt = RestoreSnapshotPlan.bind(this.restoreSnapshot, plannerContext.transactionContext(), dependencies.nodeContext(), parameters, subQueryResults, dependencies.schemas());
        Settings settings = stmt.settings();
        boolean ignoreUnavailable = SnapshotSettings.IGNORE_UNAVAILABLE.get(settings);
        IndicesOptions indicesOptions = IndicesOptions.fromOptions(ignoreUnavailable, true, true, false, IndicesOptions.LENIENT_EXPAND_OPEN);
        boolean includeTables = stmt.includeTables();
        List<RestoreSnapshotRequest.TableOrPartition> tablesToRestore = stmt.restoreTables().stream().map(restoreTableInfo -> {
            String partitionIdent = null;
            if (restoreTableInfo.partitionName() != null) {
                partitionIdent = restoreTableInfo.partitionName().ident();
            }
            return new RestoreSnapshotRequest.TableOrPartition(restoreTableInfo.tableIdent(), partitionIdent);
        }).toList();
        String tableRenamePattern = SnapshotSettings.TABLE_RENAME_PATTERN.get(settings);
        String tableRenameReplacement = SnapshotSettings.TABLE_RENAME_REPLACEMENT.get(settings);
        String schemaRenamePattern = SnapshotSettings.SCHEMA_RENAME_PATTERN.get(settings);
        String schemaRenameReplacement = SnapshotSettings.SCHEMA_RENAME_REPLACEMENT.get(settings);
        RestoreSnapshotRequest request = new RestoreSnapshotRequest(this.restoreSnapshot.repository(), this.restoreSnapshot.snapshot()).tablesToRestore(tablesToRestore).tableRenamePattern(tableRenamePattern).tableRenameReplacement(tableRenameReplacement).schemaRenamePattern(schemaRenamePattern).schemaRenameReplacement(schemaRenameReplacement).indicesOptions(indicesOptions).settings(settings).waitForCompletion(SnapshotSettings.WAIT_FOR_COMPLETION.get(settings)).includeIndices(includeTables).includeAliases(includeTables).includeCustomMetadata(stmt.includeCustomMetadata()).customMetadataTypes(stmt.customMetadataTypes()).includeGlobalSettings(stmt.includeGlobalSettings()).globalSettings(stmt.globalSettings());
        dependencies.client().execute(RestoreSnapshotAction.INSTANCE, request).whenComplete(new OneRowActionListener<RestoreSnapshotResponse>(consumer, r -> new Row1((Object)(r == null ? -1L : 1L))));
    }

    @VisibleForTesting
    public static BoundRestoreSnapshot bind(AnalyzedRestoreSnapshot restoreSnapshot, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults, Schemas schemas) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, parameters, subQueryResults);
        GenericProperties properties = restoreSnapshot.properties().ensureContainsOnly(SnapshotSettings.SETTINGS.keySet()).map(eval);
        Settings settings = Settings.builder().put((GenericProperties<Object>)properties).build();
        HashSet<BoundRestoreSnapshot.RestoreTableInfo> restoreTables = HashSet.newHashSet(restoreSnapshot.tables().size());
        for (Table<Symbol> table : restoreSnapshot.tables()) {
            PartitionName partitionName;
            RelationName relationName = RelationName.of(table.getName(), txnCtx.sessionSettings().searchPath().currentSchema());
            List partitionProperties = Lists.map((Collection)table.partitionProperties(), x -> x.map(eval));
            try {
                DocTableInfo docTableInfo = (DocTableInfo)schemas.getTableInfo(relationName);
                Operation.blockedRaiseException(docTableInfo, Operation.RESTORE_SNAPSHOT);
                partitionName = partitionProperties.isEmpty() ? null : PartitionName.ofAssignmentsUnsafe(docTableInfo, partitionProperties);
                restoreTables.add(new BoundRestoreSnapshot.RestoreTableInfo(relationName, partitionName));
            }
            catch (RelationUnknown | SchemaUnknownException e) {
                if (table.partitionProperties().isEmpty()) {
                    restoreTables.add(new BoundRestoreSnapshot.RestoreTableInfo(relationName, null));
                    continue;
                }
                partitionName = PartitionName.ofAssignments(relationName, partitionProperties);
                restoreTables.add(new BoundRestoreSnapshot.RestoreTableInfo(relationName, partitionName));
            }
        }
        return new BoundRestoreSnapshot(restoreSnapshot.repository(), restoreSnapshot.snapshot(), restoreTables, restoreSnapshot.includeTables(), restoreSnapshot.includeCustomMetadata(), restoreSnapshot.customMetadataTypes(), restoreSnapshot.includeGlobalSettings(), restoreSnapshot.globalSettings(), settings);
    }
}

