/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.management;

import io.crate.analyze.SymbolEvaluator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.jobs.kill.KillAllNodeAction;
import io.crate.execution.jobs.kill.KillAllRequest;
import io.crate.execution.jobs.kill.KillJobsNodeAction;
import io.crate.execution.jobs.kill.KillJobsNodeRequest;
import io.crate.execution.jobs.kill.KillResponse;
import io.crate.execution.support.ActionExecutor;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class KillPlan
implements Plan {
    @Nullable
    private final Symbol jobId;

    public KillPlan(@Nullable Symbol jobId) {
        this.jobId = jobId;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.MANAGEMENT;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        this.execute(KillPlan.boundJobId(this.jobId, plannerContext.transactionContext(), dependencies.nodeContext(), params, subQueryResults), plannerContext.transactionContext().sessionSettings().userName(), (KillJobsNodeRequest req) -> dependencies.client().execute(KillJobsNodeAction.INSTANCE, req), (KillAllRequest req) -> dependencies.client().execute(KillAllNodeAction.INSTANCE, req), consumer);
    }

    @VisibleForTesting
    @Nullable
    public static UUID boundJobId(@Nullable Symbol jobId, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults) {
        if (jobId != null) {
            try {
                return UUID.fromString(DataTypes.STRING.sanitizeValue(SymbolEvaluator.evaluate(txnCtx, nodeCtx, jobId, parameters, subQueryResults)));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can not parse job ID: " + String.valueOf(jobId), e);
            }
        }
        return null;
    }

    @VisibleForTesting
    void execute(@Nullable UUID jobId, String userName, ActionExecutor<KillJobsNodeRequest, KillResponse> killJobsNodeAction, ActionExecutor<KillAllRequest, KillResponse> killAllNodeAction, RowConsumer consumer) {
        if (jobId != null) {
            killJobsNodeAction.execute(new KillJobsNodeRequest(List.of(), List.of(jobId), userName, "KILL invoked by user: " + userName)).whenComplete(new OneRowActionListener<KillResponse>(consumer, killResponse -> new Row1((Object)killResponse.numKilled())));
        } else {
            killAllNodeAction.execute(new KillAllRequest(userName)).whenComplete(new OneRowActionListener<KillResponse>(consumer, killResponse -> new Row1((Object)killResponse.numKilled())));
        }
    }
}

