/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;

public final class EnsureNoMatchPredicate
extends SymbolVisitor<String, Void> {
    private static final EnsureNoMatchPredicate NO_PREDICATE_VISITOR = new EnsureNoMatchPredicate();

    private EnsureNoMatchPredicate() {
    }

    public static void ensureNoMatchPredicate(Symbol symbolTree, String errorMsg) {
        symbolTree.accept(NO_PREDICATE_VISITOR, errorMsg);
    }

    @Override
    public Void visitMatchPredicate(MatchPredicate matchPredicate, String errorMsg) {
        throw new UnsupportedFeatureException(errorMsg);
    }

    @Override
    public Void visitFunction(Function symbol, String errorMsg) {
        if (symbol.name().equals("match")) {
            throw new UnsupportedFeatureException(errorMsg);
        }
        for (Symbol argument : symbol.arguments()) {
            argument.accept(this, errorMsg);
        }
        return null;
    }
}

