/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.analyze.WhereClause;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.ForeignCollectPhase;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.fdw.ForeignDataWrapper;
import io.crate.fdw.ForeignTableRelation;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.node.dql.Collect;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class ForeignCollect
implements LogicalPlan {
    private final ForeignDataWrapper fdw;
    private final ForeignTableRelation relation;
    private final List<Symbol> toCollect;
    private final WhereClause where;
    private final String executeAs;

    public ForeignCollect(ForeignDataWrapper fdw, ForeignTableRelation relation, List<Symbol> toCollect, WhereClause where, String executeAs) {
        this.fdw = fdw;
        this.relation = relation;
        this.toCollect = toCollect;
        this.where = where;
        this.executeAs = executeAs;
    }

    @Override
    public ExecutionPlan build(DependencyCarrier dependencyCarrier, PlannerContext plannerContext, Set<PlanHint> planHints, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(plannerContext.nodeContext(), RowGranularity.DOC, null, this.relation);
        Function binder = new SubQueryAndParamBinder(params, subQueryResults).andThen(x -> normalizer.normalize((Symbol)x, plannerContext.transactionContext()));
        ForeignCollectPhase phase = new ForeignCollectPhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), plannerContext.handlerNode(), this.relation.relationName(), Lists.map(this.toCollect, binder), this.where.map(binder).queryOrFallback(), this.executeAs);
        return new Collect(phase, -1, 0, this.toCollect.size(), -1, null);
    }

    public ForeignDataWrapper fdw() {
        return this.fdw;
    }

    public ForeignTableRelation relation() {
        return this.relation;
    }

    public WhereClause where() {
        return this.where;
    }

    @Override
    public List<Symbol> outputs() {
        return this.toCollect;
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of();
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        assert (sources.isEmpty()) : "ForeignCollect has no sources, cannot replace them";
        return this;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        if (outputsToKeep.containsAll(this.toCollect)) {
            return this;
        }
        return new ForeignCollect(this.fdw, this.relation, List.copyOf(outputsToKeep), this.where, this.executeAs);
    }

    public String executeAs() {
        return this.executeAs;
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return Map.of();
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitForeignCollect(this, context);
    }

    @Override
    public List<RelationName> relationNames() {
        return List.of(this.relation.relationName());
    }

    @Override
    public void print(PrintContext printContext) {
        printContext.text("ForeignCollect[").text(this.relation.relationName().toString()).text(" | [").text(Lists.joinOn((String)", ", this.toCollect, (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)())).text("] | ").text(this.where.queryOrFallback().toString()).text("]");
        this.printStats(printContext);
    }
}

