/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.expression.scalar.SubscriptFunctions;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.FunctionCopyVisitor;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import java.util.List;
import java.util.Map;

public final class MapBackedSymbolReplacer
extends FunctionCopyVisitor<Map<Symbol, Symbol>> {
    private static final MapBackedSymbolReplacer INSTANCE = new MapBackedSymbolReplacer();

    private MapBackedSymbolReplacer() {
    }

    public static Symbol convert(Symbol symbol, Map<Symbol, Symbol> replacements) {
        return replacements.getOrDefault(symbol, symbol.accept(INSTANCE, replacements));
    }

    @Override
    protected Symbol visitSymbol(Symbol symbol, Map<Symbol, Symbol> map) {
        return map.getOrDefault(symbol, symbol);
    }

    @Override
    public Symbol visitField(ScopedSymbol symbol, Map<Symbol, Symbol> map) {
        Symbol replacedSymbol = map.get(symbol);
        if (replacedSymbol != null) {
            return replacedSymbol;
        }
        ColumnIdent symbolCol = symbol.toColumn();
        for (Map.Entry<Symbol, Symbol> entry : map.entrySet()) {
            ColumnIdent col = entry.getKey().toColumn();
            if (!symbolCol.isChildOf(col)) continue;
            Symbol fetchStub = entry.getValue();
            List<String> subscriptPath = symbolCol.getRelativePath(col);
            return SubscriptFunctions.tryCreateSubscript(fetchStub, subscriptPath);
        }
        return symbol;
    }

    @Override
    public Symbol visitFunction(Function func, Map<Symbol, Symbol> map) {
        Symbol mappedFunc = map.get(func);
        if (mappedFunc == null) {
            return this.processAndMaybeCopy(func, map);
        }
        return mappedFunc;
    }
}

