/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.matcher;

import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Match;
import io.crate.planner.optimizer.matcher.Pattern;
import java.util.function.Function;
import java.util.function.UnaryOperator;

class WithPattern<T, U, V>
extends Pattern<T> {
    private final Pattern<T> firstPattern;
    private final Function<? super T, U> getProperty;
    private final Pattern<V> propertyPattern;

    WithPattern(Pattern<T> firstPattern, Function<? super T, U> getProperty, Pattern<V> propertyPattern) {
        this.firstPattern = firstPattern;
        this.getProperty = getProperty;
        this.propertyPattern = propertyPattern;
    }

    @Override
    public Match<T> accept(Object object, Captures captures, UnaryOperator<LogicalPlan> resolvePlan) {
        Match<Object> match = this.firstPattern.accept(object, captures, resolvePlan);
        return match.flatMap(matchedValue -> {
            Object object;
            U value = this.getProperty.apply(matchedValue);
            if (value == null) {
                return match;
            }
            if (value instanceof LogicalPlan) {
                LogicalPlan logicalPlan = (LogicalPlan)value;
                object = resolvePlan.apply(logicalPlan);
            } else {
                object = value;
            }
            value = object;
            return this.propertyPattern.accept(value, match.captures(), resolvePlan).map(ignored -> match.value());
        });
    }
}

