/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.matcher;

import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Match;
import io.crate.planner.optimizer.matcher.Pattern;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class WithPropertyPattern<T>
extends Pattern<T> {
    private final Pattern<T> pattern;
    private final Predicate<? super T> propertyPredicate;

    WithPropertyPattern(Pattern<T> pattern, Predicate<? super T> propertyPredicate) {
        this.pattern = pattern;
        this.propertyPredicate = propertyPredicate;
    }

    @Override
    public Match<T> accept(Object object, Captures captures, UnaryOperator<LogicalPlan> resolvePlan) {
        Match<Object> match = this.pattern.accept(object, captures, resolvePlan);
        return match.flatMap(matchedValue -> {
            if (this.propertyPredicate.test(matchedValue)) {
                return match;
            }
            return Match.empty();
        });
    }
}

