/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.where.DocKeys;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import io.crate.planner.WhereClauseOptimizer;
import io.crate.planner.operators.Collect;
import io.crate.planner.operators.Get;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import java.util.Optional;

public final class OptimizeCollectWhereClauseAccess
implements Rule<Collect> {
    private final Pattern<Collect> pattern = Pattern.typeOf(Collect.class).with(collect -> collect.relation() instanceof DocTableRelation && collect.where().hasQuery() && !Symbols.hasColumn(collect.outputs(), SysColumns.FETCHID));

    @Override
    public Pattern<Collect> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Collect collect, Captures captures, Rule.Context context) {
        WhereClause where;
        DocTableRelation relation = (DocTableRelation)collect.relation();
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(context.nodeCtx(), RowGranularity.CLUSTER, null, relation);
        WhereClauseOptimizer.DetailedQuery detailedQuery = WhereClauseOptimizer.optimize(normalizer, (where = collect.where()).queryOrFallback(), (DocTableInfo)relation.tableInfo(), context.txnCtx(), context.nodeCtx(), context.timeoutToken());
        Optional<DocKeys> docKeys = detailedQuery.docKeys();
        if (docKeys.isPresent()) {
            return new Get(relation, docKeys.get(), detailedQuery.query(), collect.outputs(), detailedQuery.queryHasPkSymbolsOnly());
        }
        if (!detailedQuery.clusteredBy().isEmpty() && collect.detailedQuery() == null) {
            return new Collect(collect, detailedQuery);
        }
        return null;
    }
}

