/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.symbol.rule;

import io.crate.expression.operator.all.AllOperator;
import io.crate.expression.operator.any.AnyEqOperator;
import io.crate.expression.operator.any.AnyNeqOperator;
import io.crate.expression.operator.any.AnyOperator;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.metadata.NodeContext;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.symbol.FunctionLookup;
import io.crate.planner.optimizer.symbol.Rule;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import java.util.List;

public class MoveReferenceCastToLiteralCastOnArrayOperatorsWhenRightIsReference
implements Rule<Function> {
    private final Capture<Function> castCapture = new Capture();
    private final Pattern<Function> pattern = Pattern.typeOf(Function.class).with(f -> AnyOperator.OPERATOR_NAMES.contains(f.name()) || AllOperator.OPERATOR_NAMES.contains(f.name())).with(f -> f.arguments().get(0).symbolType().isValueOrParameterSymbol()).with(f -> f.arguments().get(1), Pattern.typeOf(Function.class).capturedAs(this.castCapture).with(f -> f.isCast() && CastMode.IMPLICIT.equals((Object)f.castMode())).with(f -> f.arguments().get(0).symbolType() == SymbolType.REFERENCE));

    @Override
    public Pattern<Function> pattern() {
        return this.pattern;
    }

    @Override
    public Symbol apply(Function operator, Captures captures, NodeContext nodeCtx, FunctionLookup functionLookup, Symbol parentNode) {
        Symbol literalOrParam = operator.arguments().get(0);
        Function castFunction = captures.get(this.castCapture);
        Symbol reference = castFunction.arguments().get(0);
        DataType<Object> targetType = reference.valueType();
        if (targetType.id() != 100) {
            return null;
        }
        targetType = ((ArrayType)targetType).innerType();
        String operatorName = operator.name();
        if (!List.of(AnyEqOperator.NAME, AnyNeqOperator.NAME).contains(operatorName) && literalOrParam.valueType().id() == 100) {
            return null;
        }
        return functionLookup.get(operator.name(), List.of(literalOrParam.cast(targetType, new CastMode[0]), reference));
    }
}

