/*
 * Decompiled with CFR 0.152.
 */
package io.crate.profile;

public final class Timer {
    private final String name;
    private long duration;
    private long startTime;
    private boolean running;

    Timer(String name) {
        this.name = name;
        this.running = false;
    }

    public String name() {
        return this.name;
    }

    public void start() {
        if (this.running) {
            throw new IllegalStateException("Timer is already running");
        }
        this.running = true;
        this.startTime = System.nanoTime();
    }

    public void stop() {
        if (!this.running) {
            throw new IllegalStateException("Timer is not running and cannot be stopped");
        }
        this.duration += System.nanoTime() - this.startTime;
        this.running = false;
    }

    public long durationNanos() {
        return this.duration;
    }
}

