/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.http;

import io.crate.protocols.http.Headers;
import io.crate.protocols.http.Responses;
import io.crate.protocols.http.StaticSite;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.util.Version;
import org.elasticsearch.Build;
import org.elasticsearch.action.admin.cluster.state.ClusterStateAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.http.netty4.cors.Netty4CorsConfig;
import org.elasticsearch.http.netty4.cors.Netty4CorsHandler;
import org.elasticsearch.rest.RestStatus;
import org.jetbrains.annotations.Nullable;

public class MainAndStaticFileHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final Path sitePath;
    private final NodeClient client;
    private final Netty4CorsConfig corsConfig;
    private final String nodeName;

    public MainAndStaticFileHandler(String nodeName, Path home, NodeClient client, Netty4CorsConfig corsConfig) {
        this.nodeName = nodeName;
        this.sitePath = home.resolve("lib").resolve("site");
        this.client = client;
        this.corsConfig = corsConfig;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        switch (msg.uri().trim().toLowerCase(Locale.ENGLISH)) {
            case "/admin": 
            case "/_plugin/crate-admin": {
                this.writeResponse(ctx, msg, Responses.redirectTo("/"));
                break;
            }
            case "/index.html": {
                this.writeResponse(ctx, msg, StaticSite.serveSite(this.sitePath, msg, ctx.alloc()));
                break;
            }
            default: {
                this.serveJsonOrSite(msg, ctx.alloc()).whenComplete((resp, err) -> {
                    if (err == null) {
                        this.writeResponse(ctx, msg, (FullHttpResponse)resp);
                    } else {
                        FullHttpResponse errResp = Responses.contentResponse(HttpResponseStatus.BAD_REQUEST, ctx.alloc(), err.getMessage());
                        this.writeResponse(ctx, msg, errResp);
                    }
                });
            }
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse resp) {
        Netty4CorsHandler.setCorsResponseHeaders((HttpRequest)req, (HttpResponse)resp, this.corsConfig);
        ChannelPromise promise = ctx.newPromise();
        if (Headers.isCloseConnection(req)) {
            promise.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            Headers.setKeepAlive(req.protocolVersion(), resp);
        }
        ctx.channel().writeAndFlush((Object)resp, promise);
    }

    private CompletableFuture<FullHttpResponse> serveJsonOrSite(FullHttpRequest request, ByteBufAllocator alloc) throws IOException {
        String accept;
        HttpHeaders headers = request.headers();
        String userAgent = headers.get((CharSequence)HttpHeaderNames.USER_AGENT);
        if (MainAndStaticFileHandler.shouldServeJSON(userAgent, accept = headers.get((CharSequence)HttpHeaderNames.ACCEPT), request.uri())) {
            return this.serveJSON(request.method(), alloc);
        }
        return CompletableFuture.completedFuture(StaticSite.serveSite(this.sitePath, request, alloc));
    }

    private CompletableFuture<FullHttpResponse> serveJSON(HttpMethod method, ByteBufAllocator alloc) {
        ClusterStateRequest requestClusterState = (ClusterStateRequest)new ClusterStateRequest().blocks(true).metadata(false).nodes(false).local(true);
        return this.client.execute(ClusterStateAction.INSTANCE, requestClusterState).thenApply(resp -> MainAndStaticFileHandler.clusterStateRespToHttpResponse(method, resp, alloc, this.nodeName));
    }

    private static FullHttpResponse clusterStateRespToHttpResponse(HttpMethod method, ClusterStateResponse response, ByteBufAllocator alloc, @Nullable String nodeName) {
        HttpResponseStatus httpStatus = response.getState().blocks().hasGlobalBlockWithStatus(RestStatus.SERVICE_UNAVAILABLE) ? HttpResponseStatus.SERVICE_UNAVAILABLE : HttpResponseStatus.OK;
        try {
            DefaultFullHttpResponse resp;
            if (method == HttpMethod.HEAD) {
                resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, httpStatus);
                HttpUtil.setContentLength((HttpMessage)resp, (long)0L);
            } else {
                ByteBuf buffer = alloc.buffer();
                try (ByteBufOutputStream outputStream = new ByteBufOutputStream(buffer);){
                    MainAndStaticFileHandler.writeJSON((OutputStream)outputStream, response, httpStatus, nodeName);
                }
                resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, httpStatus, buffer);
                resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
                HttpUtil.setContentLength((HttpMessage)resp, (long)buffer.readableBytes());
            }
            return resp;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeJSON(OutputStream outputStream, ClusterStateResponse response, HttpResponseStatus status, @Nullable String nodeName) throws IOException {
        XContentBuilder builder = new XContentBuilder((XContent)JsonXContent.JSON_XCONTENT, outputStream);
        builder.prettyPrint().lfAtEnd();
        builder.startObject();
        builder.field("ok", status == HttpResponseStatus.OK);
        builder.field("status", status.code());
        if (nodeName != null && !nodeName.isEmpty()) {
            builder.field("name", nodeName);
        }
        builder.field("cluster_name", response.getClusterName().value());
        builder.startObject("version").field("number", org.elasticsearch.Version.CURRENT.externalNumber()).field("build_hash", Build.CURRENT.hash()).field("build_timestamp", Build.CURRENT.timestamp()).field("build_snapshot", org.elasticsearch.Version.CURRENT.isSnapshot()).field("lucene_version", Version.LATEST.toString()).endObject();
        builder.endObject();
        builder.flush();
        builder.close();
    }

    private static boolean shouldServeJSON(String userAgent, String accept, String uri) {
        boolean isRoot = uri.equals("/");
        boolean forceJson = Headers.isAcceptJson(accept);
        return isRoot && (forceJson || !Headers.isBrowser(userAgent));
    }
}

