/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public record KeyData(int pid, int secretKey) implements Writeable
{
    static KeyData generate(int pid) {
        int secretKey = ThreadLocalRandom.current().nextInt();
        return new KeyData(pid, secretKey);
    }

    static KeyData of(ByteBuf buffer) {
        return new KeyData(buffer.readInt(), buffer.readInt());
    }

    public static KeyData of(StreamInput in) throws IOException {
        int pid = in.readInt();
        int secretKey = in.readInt();
        return new KeyData(pid, secretKey);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.pid);
        out.writeInt(this.secretKey);
    }
}

