/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.BaseTimestampType;
import io.crate.protocols.postgres.types.PGArray;
import io.crate.types.Regproc;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

final class DateType
extends BaseTimestampType {
    public static final DateType INSTANCE = new DateType();
    private static final int OID = 1082;
    private static final String NAME = "date";
    private static final DateTimeFormatter ISO_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).toFormatter(Locale.ENGLISH).withResolverStyle(ResolverStyle.STRICT);
    private static final DateTimeFormatter ISO_FORMATTER_AD = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd").toFormatter(Locale.ENGLISH).withResolverStyle(ResolverStyle.STRICT);

    private DateType() {
        super(1082, 8, -1, NAME);
    }

    @Override
    public int typArray() {
        return PGArray.DATE_ARRAY.oid();
    }

    @Override
    public Regproc typSend() {
        return Regproc.of("date_send");
    }

    @Override
    public Regproc typReceive() {
        return Regproc.of("date_recv");
    }

    @Override
    byte[] encodeAsUTF8Text(@NotNull Long value) {
        long millis = value;
        LocalDate date = LocalDate.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
        return date.format(ISO_FORMATTER_AD).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    Long decodeUTF8Text(byte[] bytes) {
        String s = new String(bytes, StandardCharsets.UTF_8);
        LocalDate dt = LocalDate.parse(s, ISO_FORMATTER);
        return dt.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
    }
}

