/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import com.carrotsearch.hppc.ByteArrayList;
import io.crate.data.Row;
import io.crate.protocols.postgres.types.PGType;
import io.crate.types.Regproc;
import io.netty.buffer.ByteBuf;
import java.util.List;

public class RecordType
extends PGType<Row> {
    static final int OID = 2249;
    static final String NAME = "record";
    static final RecordType EMPTY_RECORD = new RecordType(List.of());
    private final List<PGType<?>> fieldTypes;

    RecordType(List<PGType<?>> fieldTypes) {
        super(2249, -1, -1, NAME);
        this.fieldTypes = fieldTypes;
    }

    @Override
    public int typArray() {
        return 2287;
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.PSEUDO.code();
    }

    @Override
    public String type() {
        return PGType.Type.PSEUDO.code();
    }

    @Override
    public Regproc typSend() {
        return Regproc.of("record_send");
    }

    @Override
    public Regproc typReceive() {
        return Regproc.of("record_recv");
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, Row record) {
        int startWriterIndex = buffer.writerIndex();
        buffer.writeInt(0);
        buffer.writeInt(this.fieldTypes.size());
        int bytesWritten = 4;
        for (int i = 0; i < this.fieldTypes.size(); ++i) {
            PGType<?> fieldType = this.fieldTypes.get(i);
            buffer.writeInt(fieldType.oid());
            bytesWritten += 4;
            Object value = record.get(i);
            if (value == null) {
                buffer.writeInt(-1);
                continue;
            }
            bytesWritten += fieldType.writeAsBinary(buffer, value);
        }
        buffer.setInt(startWriterIndex, bytesWritten);
        return 4 + bytesWritten;
    }

    @Override
    public Row readBinaryValue(ByteBuf buffer, int valueLength) {
        throw new UnsupportedOperationException("Input of anonymous record type values is not implemented");
    }

    @Override
    byte[] encodeAsUTF8Text(Row record) {
        ByteArrayList bytes = new ByteArrayList();
        bytes.add((byte)40);
        for (int i = 0; i < record.numColumns(); ++i) {
            PGType<?> fieldType = this.fieldTypes.get(i);
            Object value = record.get(i);
            if (i > 0) {
                bytes.add((byte)44);
            }
            if (value == null) continue;
            byte[] encodedValue = fieldType.encodeAsUTF8Text(value);
            boolean needQuotes = encodedValue.length == 0;
            for (int j = 0; j < encodedValue.length; ++j) {
                char c = (char)encodedValue[j];
                if (c != '\"' && c != '\\' && c != '(' && c != ')' && c != ',' && !Character.isWhitespace(c)) continue;
                needQuotes = true;
                break;
            }
            if (needQuotes) {
                bytes.add((byte)34);
            }
            bytes.add(encodedValue);
            if (!needQuotes) continue;
            bytes.add((byte)34);
        }
        bytes.add((byte)41);
        return bytes.toArray();
    }

    @Override
    Row decodeUTF8Text(byte[] bytes) {
        throw new UnsupportedOperationException("Input of record type values is not implemented");
    }
}

