/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import io.crate.replication.logical.action.DropPublicationRequest;
import io.crate.replication.logical.exceptions.PublicationUnknownException;
import io.crate.replication.logical.metadata.PublicationsMetadata;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportDropPublicationAction
extends AbstractDDLTransportAction<DropPublicationRequest, AcknowledgedResponse> {
    public static final String ACTION_NAME = "internal:crate:replication/logical/publication/drop";

    @Inject
    public TransportDropPublicationAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(ACTION_NAME, transportService, clusterService, threadPool, DropPublicationRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "drop-publication");
    }

    @Override
    public ClusterStateTaskExecutor<DropPublicationRequest> clusterStateTaskExecutor(DropPublicationRequest request) {
        return new DDLClusterStateTaskExecutor<DropPublicationRequest>(this){

            @Override
            protected ClusterState execute(ClusterState currentState, DropPublicationRequest request) throws Exception {
                Metadata currentMetadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
                PublicationsMetadata oldMetadata = (PublicationsMetadata)mdBuilder.getCustom("publications");
                if (oldMetadata == null && !request.ifExists()) {
                    throw new PublicationUnknownException(request.name());
                }
                if (oldMetadata != null) {
                    if (oldMetadata.publications().containsKey(request.name())) {
                        PublicationsMetadata newMetadata = PublicationsMetadata.newInstance(oldMetadata);
                        newMetadata.publications().remove(request.name());
                        assert (!newMetadata.equals(oldMetadata)) : "must not be equal to guarantee the cluster change action";
                        mdBuilder.putCustom("publications", newMetadata);
                        return ClusterState.builder(currentState).metadata(mdBuilder).build();
                    }
                    if (!request.ifExists()) {
                        throw new PublicationUnknownException(request.name());
                    }
                }
                return currentState;
            }
        };
    }

    @Override
    protected ClusterBlockException checkBlock(DropPublicationRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

