/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.metadata;

import io.crate.metadata.RelationName;
import io.crate.replication.logical.metadata.ConnectionInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class Subscription
implements Writeable {
    private final String owner;
    private final ConnectionInfo connectionInfo;
    private final List<String> publications;
    private final Settings settings;
    private final Map<RelationName, RelationState> relations;

    public static RelationState updateRelationState(@Nullable RelationState oldState, RelationState newState) {
        if (oldState == null) {
            return newState;
        }
        if (oldState.state.equals((Object)newState.state)) {
            return oldState;
        }
        return newState;
    }

    public Subscription(String owner, ConnectionInfo connectionInfo, List<String> publications, Settings settings, Map<RelationName, RelationState> relations) {
        this.owner = owner;
        this.connectionInfo = connectionInfo;
        this.publications = publications;
        this.settings = settings;
        this.relations = relations;
    }

    public Subscription(StreamInput in) throws IOException {
        this.owner = in.readString();
        this.connectionInfo = new ConnectionInfo(in);
        this.publications = Arrays.stream(in.readStringArray()).toList();
        this.settings = Settings.readSettingsFromStream(in);
        int relSize = in.readVInt();
        HashMap<RelationName, RelationState> relations = new HashMap<RelationName, RelationState>();
        for (int i = 0; i < relSize; ++i) {
            RelationName relationName = new RelationName(in);
            RelationState relationState = RelationState.readFrom(in);
            relations.put(relationName, relationState);
        }
        this.relations = relations;
    }

    public String owner() {
        return this.owner;
    }

    public ConnectionInfo connectionInfo() {
        return this.connectionInfo;
    }

    public List<String> publications() {
        return this.publications;
    }

    public Settings settings() {
        return this.settings;
    }

    public Map<RelationName, RelationState> relations() {
        return this.relations;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.owner);
        this.connectionInfo.writeTo(out);
        out.writeStringArray(this.publications.toArray(new String[0]));
        Settings.writeSettingsToStream(out, this.settings);
        out.writeVInt(this.relations.size());
        for (Map.Entry<RelationName, RelationState> entry : this.relations.entrySet()) {
            entry.getKey().writeTo(out);
            RelationState.writeTo(out, entry.getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        return this.owner.equals(that.owner) && this.connectionInfo.equals(that.connectionInfo) && this.publications.equals(that.publications) && this.settings.equals(that.settings) && this.relations.equals(that.relations);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.connectionInfo, this.publications, this.settings, this.relations);
    }

    public String toString() {
        return "Subscription{owner='" + this.owner + "', connectionInfo=" + String.valueOf(this.connectionInfo) + ", publications=" + String.valueOf(this.publications) + ", settings=" + String.valueOf(this.settings) + ", relations=" + String.valueOf(this.relations) + "}";
    }

    public record RelationState(State state, @Nullable String reason) {
        public static void writeTo(StreamOutput out, RelationState relationState) throws IOException {
            out.writeVInt(relationState.state.ordinal());
            out.writeOptionalString(relationState.reason);
        }

        public static RelationState readFrom(StreamInput in) throws IOException {
            return new RelationState(State.VALUES[in.readVInt()], in.readOptionalString());
        }
    }

    public static enum State {
        INITIALIZING("i"),
        RESTORING("d"),
        MONITORING("r"),
        FAILED("e");

        private static final State[] VALUES;
        private final String pg_state;

        private State(String pg_state) {
            this.pg_state = pg_state;
        }

        public String pg_state() {
            return this.pg_state;
        }

        static {
            VALUES = State.values();
        }
    }
}

