/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParser;
import org.jetbrains.annotations.NotNull;

public record GrantedRole(String roleName, String grantor) implements Writeable,
Comparable<GrantedRole>
{
    public GrantedRole(StreamInput in) throws IOException {
        this(in.readString(), in.readString());
    }

    public static GrantedRole fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse a granted role, expecting the current token to be a start_object, got " + String.valueOf(parser.currentToken()), new Object[0]);
        }
        String role = null;
        String grantor = null;
        while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
            switch (parser.currentName()) {
                case "role": {
                    parser.nextToken();
                    role = parser.text();
                    break;
                }
                case "grantor": {
                    parser.nextToken();
                    grantor = parser.text();
                    break;
                }
            }
        }
        if (parser.currentToken() != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("failed to parse a granted role, expecting the current token to be a end_object, got " + String.valueOf(parser.currentToken()), new Object[0]);
        }
        return new GrantedRole(role, grantor);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.roleName);
        out.writeString(this.grantor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantedRole that = (GrantedRole)o;
        return Objects.equals(this.roleName, that.roleName) && Objects.equals(this.grantor, that.grantor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.roleName, this.grantor);
    }

    @Override
    public String toString() {
        return "GrantedRole{" + this.roleName + ", grantor: " + this.grantor + "}";
    }

    @Override
    public int compareTo(@NotNull GrantedRole o) {
        int cmp = this.roleName.compareTo(o.roleName);
        if (cmp != 0) {
            return cmp;
        }
        return this.grantor.compareTo(o.grantor);
    }
}

