/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.exceptions.MissingPrivilegeException;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.SchemaUnknownException;
import io.crate.metadata.IndexName;
import io.crate.metadata.RelationName;
import io.crate.role.Permission;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.Securable;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class Privileges {
    private Privileges() {
    }

    public static void ensureUserHasPrivilege(Roles roles, Role user, Permission permission, Securable securable, @Nullable String ident) throws MissingPrivilegeException {
        assert (roles != null) : "Roles must not be null when trying to validate privileges";
        assert (user != null) : "User must not be null when trying to validate privileges";
        assert (permission != null) : "Permission must not be null";
        if (Privileges.isInformationSchema(securable, ident) || Privileges.isPgCatalogSchema(securable, ident)) {
            return;
        }
        if (!roles.hasPrivilege(user, permission, securable, ident)) {
            boolean objectIsVisibleToUser = roles.hasAnyPrivilege(user, securable, ident);
            if (objectIsVisibleToUser) {
                throw new MissingPrivilegeException(user.name(), permission);
            }
            switch (securable) {
                case CLUSTER: {
                    throw new MissingPrivilegeException(user.name(), permission);
                }
                case SCHEMA: {
                    throw new SchemaUnknownException(ident);
                }
                case TABLE: 
                case VIEW: {
                    RelationName relationName = RelationName.fromIndexName(ident);
                    if (roles.hasAnyPrivilege(user, Securable.SCHEMA, relationName.schema())) {
                        throw new RelationUnknown(relationName);
                    }
                    throw new SchemaUnknownException(relationName.schema());
                }
            }
            throw new AssertionError((Object)("Invalid securable: " + String.valueOf((Object)securable)));
        }
    }

    @VisibleForTesting
    public static void ensureUserHasPrivilege(Roles roles, Role user, Securable securable, @Nullable String ident) throws MissingPrivilegeException {
        assert (roles != null) : "Roles must not be null when trying to validate privileges";
        assert (user != null) : "User must not be null when trying to validate privileges";
        if (Privileges.isInformationSchema(securable, ident) || Privileges.isPgCatalogSchema(securable, ident)) {
            return;
        }
        if (!roles.hasAnyPrivilege(user, securable, ident)) {
            switch (securable) {
                case CLUSTER: {
                    throw new MissingPrivilegeException(user.name());
                }
                case SCHEMA: {
                    throw new SchemaUnknownException(ident);
                }
                case TABLE: 
                case VIEW: {
                    RelationName relationName = RelationName.fromIndexName(ident);
                    if (roles.hasAnyPrivilege(user, Securable.SCHEMA, relationName.schema())) {
                        throw new RelationUnknown(relationName);
                    }
                    throw new SchemaUnknownException(relationName.schema());
                }
            }
            throw new AssertionError((Object)("Invalid securable: " + String.valueOf((Object)securable)));
        }
    }

    private static String getTargetSchema(Securable securable, @Nullable String ident) {
        String schemaName = null;
        if (Securable.CLUSTER.equals((Object)securable)) {
            return schemaName;
        }
        assert (ident != null) : "ident must not be null if privilege securable is not 'CLUSTER'";
        schemaName = Securable.TABLE.equals((Object)securable) ? IndexName.decode(ident).schema() : ident;
        return schemaName;
    }

    private static boolean isInformationSchema(Securable securable, String ident) {
        String targetSchema = Privileges.getTargetSchema(securable, ident);
        return "information_schema".equals(targetSchema);
    }

    private static boolean isPgCatalogSchema(Securable securable, String ident) {
        String targetSchema = Privileges.getTargetSchema(securable, ident);
        return "pg_catalog".equals(targetSchema);
    }
}

