/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.replication.logical.LogicalReplicationService;
import io.crate.role.DropRoleRequest;
import io.crate.role.DropRoleTask;
import io.crate.role.WriteRoleResponse;
import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDropRoleAction
extends TransportMasterNodeAction<DropRoleRequest, WriteRoleResponse> {
    public static final Action ACTION = new Action();
    private final LogicalReplicationService logicalReplicationService;

    @Inject
    public TransportDropRoleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, LogicalReplicationService logicalReplicationService) {
        super(ACTION.name(), transportService, clusterService, threadPool, DropRoleRequest::new);
        this.logicalReplicationService = logicalReplicationService;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected WriteRoleResponse read(StreamInput in) throws IOException {
        return new WriteRoleResponse(in);
    }

    @Override
    protected void masterOperation(DropRoleRequest request, ClusterState state, ActionListener<WriteRoleResponse> listener) throws Exception {
        if (!state.nodes().getMinNodeVersion().onOrAfter(Version.V_5_6_0)) {
            throw new IllegalStateException("Cannot drop users/roles until all nodes are upgraded to 5.6");
        }
        String errorMsg = "User '%s' cannot be dropped. %s '%s' needs to be dropped first.";
        this.logicalReplicationService.subscriptions().forEach((key, value) -> {
            if (value.owner().equals(request.roleName())) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, errorMsg, request.roleName(), "Subscription", key));
            }
        });
        this.logicalReplicationService.publications().forEach((key, value) -> {
            if (value.owner().equals(request.roleName())) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, errorMsg, request.roleName(), "Publication", key));
            }
        });
        DropRoleTask dropRoleTask = new DropRoleTask(request);
        dropRoleTask.completionFuture().whenComplete(listener);
        this.clusterService.submitStateUpdateTask("drop_role [" + request.roleName() + "]", dropRoleTask);
    }

    @Override
    protected ClusterBlockException checkBlock(DropRoleRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    public static class Action
    extends ActionType<WriteRoleResponse> {
        private static String NAME = "internal:crate:sql/user/drop";

        private Action() {
            super(NAME);
        }
    }
}

