/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role.metadata;

import io.crate.role.GrantedRole;
import io.crate.role.GrantedRolesChange;
import io.crate.role.JwtProperties;
import io.crate.role.Policy;
import io.crate.role.Role;
import io.crate.role.SecureHash;
import io.crate.role.metadata.UsersMetadata;
import io.crate.role.metadata.UsersPrivilegesMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentParser;
import org.jetbrains.annotations.Nullable;

public class RolesMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "roles";
    private final Map<String, Role> roles;

    public RolesMetadata() {
        this.roles = new HashMap<String, Role>();
    }

    public RolesMetadata(Map<String, Role> roles) {
        this.roles = roles;
    }

    public static RolesMetadata newInstance(@Nullable RolesMetadata instance) {
        if (instance == null) {
            return new RolesMetadata();
        }
        return new RolesMetadata(new HashMap<String, Role>(instance.roles));
    }

    public static RolesMetadata ofOldUsersMetadata(@Nullable UsersMetadata usersMetadata, @Nullable UsersPrivilegesMetadata usersPrivilegesMetadata) {
        if (usersMetadata == null) {
            return null;
        }
        Function<String, Set> getPrivileges = username -> Set.of();
        if (usersPrivilegesMetadata != null) {
            getPrivileges = usersPrivilegesMetadata::getUserPrivileges;
        }
        RolesMetadata rolesMetadata = new RolesMetadata();
        for (Map.Entry<String, SecureHash> user : usersMetadata.users().entrySet()) {
            String userName = user.getKey();
            Role role = new Role(userName, true, getPrivileges.apply(userName), Set.of(), user.getValue(), null, Map.of());
            rolesMetadata.roles().put(userName, role);
        }
        return rolesMetadata;
    }

    public boolean contains(String name) {
        return this.roles.containsKey(name);
    }

    public boolean contains(@Nullable JwtProperties jwtProperties) {
        if (jwtProperties == null) {
            return false;
        }
        for (Role role : this.roles.values()) {
            JwtProperties jwtProps = role.jwtProperties();
            if (!role.isUser() || jwtProps == null || !jwtProps.match(jwtProperties.iss(), jwtProperties.username())) continue;
            return true;
        }
        return false;
    }

    public Role remove(String name) {
        return this.roles.remove(name);
    }

    public List<String> roleNames() {
        return new ArrayList<String>(this.roles.keySet());
    }

    public Map<String, Role> roles() {
        return this.roles;
    }

    public RolesMetadata(StreamInput in) throws IOException {
        int numRoles = in.readVInt();
        this.roles = HashMap.newHashMap(numRoles);
        for (int i = 0; i < numRoles; ++i) {
            Role role = new Role(in);
            this.roles.put(role.name(), role);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.roles.size());
        for (Role role : this.roles.values()) {
            role.writeTo(out);
        }
    }

    public static RolesMetadata fromXContent(XContentParser parser) throws IOException {
        HashMap<String, Role> roles = new HashMap<String, Role>();
        XContentParser.Token token = parser.nextToken();
        if (token == XContentParser.Token.FIELD_NAME && parser.currentName().equals(TYPE)) {
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("failed to parse roles, expected an object token but got {}", token);
            }
            while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                Role role = Role.fromXContent(parser);
                roles.put(role.name(), role);
            }
            if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw new ElasticsearchParseException("failed to parse roles, expected an object token at the end", new Object[0]);
            }
        }
        return new RolesMetadata(roles);
    }

    public static RolesMetadata of(Metadata.Builder mdBuilder, @Nullable UsersMetadata oldUsersMetadata, @Nullable UsersPrivilegesMetadata oldUserPrivilegesMetadata, RolesMetadata oldRolesMetadata) {
        RolesMetadata newMetadata;
        if (oldUsersMetadata != null) {
            newMetadata = RolesMetadata.ofOldUsersMetadata(oldUsersMetadata, oldUserPrivilegesMetadata);
            mdBuilder.removeCustom("users");
            mdBuilder.removeCustom("users_privileges");
        } else {
            newMetadata = RolesMetadata.newInstance(oldRolesMetadata);
        }
        return newMetadata;
    }

    public long applyRolePrivileges(Collection<String> userNames, GrantedRolesChange newGrantedRolesChange) {
        long affectedPrivileges = 0L;
        for (String userName : userNames) {
            affectedPrivileges += this.applyRolePrivilegesToUser(userName, newGrantedRolesChange);
        }
        return affectedPrivileges;
    }

    private long applyRolePrivilegesToUser(String roleName, GrantedRolesChange newGrantedRolesChange) {
        Role role = this.roles.get(roleName);
        HashSet<GrantedRole> grantedRoles = new HashSet<GrantedRole>(role.grantedRoles());
        long affectedCount = 0L;
        for (String roleNameToApply : newGrantedRolesChange.roleNames()) {
            if (newGrantedRolesChange.policy() == Policy.GRANT) {
                boolean roleAlreadyGranted = false;
                for (GrantedRole grantedRole : grantedRoles) {
                    if (!grantedRole.roleName().equals(roleNameToApply)) continue;
                    roleAlreadyGranted = true;
                    break;
                }
                if (roleAlreadyGranted) continue;
                grantedRoles.add(new GrantedRole(roleNameToApply, newGrantedRolesChange.grantor()));
                ++affectedCount;
                continue;
            }
            if (newGrantedRolesChange.policy() != Policy.REVOKE) continue;
            Iterator iterator = grantedRoles.iterator();
            while (iterator.hasNext()) {
                GrantedRole grantedRole = (GrantedRole)iterator.next();
                if (!grantedRole.roleName().equals(roleNameToApply) || !grantedRole.grantor().equals(newGrantedRolesChange.grantor()) && !Role.CRATE_USER.name().equals(newGrantedRolesChange.grantor())) continue;
                iterator.remove();
                ++affectedCount;
            }
        }
        if (affectedCount > 0L) {
            this.roles.put(role.name(), role.with(grantedRoles));
        }
        return affectedCount;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY, Metadata.XContentContext.SNAPSHOT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolesMetadata that = (RolesMetadata)o;
        return Objects.equals(this.roles, that.roles);
    }

    public int hashCode() {
        return Objects.hash(this.roles);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_5_6_0;
    }
}

