/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role.metadata;

import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.SystemTable;
import io.crate.role.Privilege;
import io.crate.role.Role;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.stream.StreamSupport;

public class SysPrivilegesTableInfo {
    public static final RelationName IDENT = new RelationName("sys", "privileges");
    public static SystemTable<PrivilegeRow> INSTANCE = ((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(IDENT).add("grantee", (DataType)DataTypes.STRING, x -> x.grantee)).add("grantor", (DataType)DataTypes.STRING, x -> x.privilege.grantor())).add("state", (DataType)DataTypes.STRING, x -> x.privilege.policy().toString())).add("type", (DataType)DataTypes.STRING, x -> x.privilege.subject().permission().toString())).add("class", (DataType)DataTypes.STRING, x -> x.privilege.subject().securable().toString())).add("ident", (DataType)DataTypes.STRING, x -> x.privilege.subject().ident())).setPrimaryKeys(ColumnIdent.of("grantee"), ColumnIdent.of("state"), ColumnIdent.of("type"), ColumnIdent.of("class"), ColumnIdent.of("ident")).build();

    public static Iterable<PrivilegeRow> buildPrivilegesRows(Iterable<Role> roles) {
        return () -> StreamSupport.stream(roles.spliterator(), false).flatMap(u -> StreamSupport.stream(u.privileges().spliterator(), false).map(p -> new PrivilegeRow(u.name(), (Privilege)p))).iterator();
    }

    public record PrivilegeRow(String grantee, Privilege privilege) {
    }
}

