/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import java.io.IOException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.elasticsearch.common.io.stream.StreamInput;

public abstract class DistinctValuesSketch {
    public abstract void update(String var1);

    public abstract DistinctValuesSketch merge(DistinctValuesSketch var1);

    public abstract Sketch getSketch();

    public static DistinctValuesSketch newSketch() {
        return new DistinctValuesSketch(){
            final UpdateSketch distinctSketch = UpdateSketch.builder().build();

            @Override
            public void update(String v) {
                this.distinctSketch.update(v);
            }

            @Override
            public DistinctValuesSketch merge(DistinctValuesSketch other) {
                Union union = SetOperation.builder().buildUnion();
                union.union((Sketch)this.distinctSketch);
                union.union(other.getSketch());
                return DistinctValuesSketch.mergedSketch(union);
            }

            @Override
            public Sketch getSketch() {
                return this.distinctSketch;
            }
        };
    }

    private static DistinctValuesSketch mergedSketch(final Union union) {
        return new DistinctValuesSketch(){

            @Override
            public void update(String v) {
                union.update(v);
            }

            @Override
            public DistinctValuesSketch merge(DistinctValuesSketch other) {
                union.union(other.getSketch());
                return DistinctValuesSketch.mergedSketch(union);
            }

            @Override
            public Sketch getSketch() {
                return union.getResult();
            }
        };
    }

    public static DistinctValuesSketch fromStream(StreamInput in) throws IOException {
        byte[] distinctSketchBytes = in.readByteArray();
        final Sketch sketch = Sketches.wrapSketch((Memory)Memory.wrap((byte[])distinctSketchBytes));
        return new DistinctValuesSketch(){

            @Override
            public void update(String v) {
                throw new UnsupportedOperationException();
            }

            @Override
            public DistinctValuesSketch merge(DistinctValuesSketch other) {
                Union union = SetOperation.builder().buildUnion();
                union.union(sketch);
                union.union(other.getSketch());
                return DistinctValuesSketch.mergedSketch(union);
            }

            @Override
            public Sketch getSketch() {
                return sketch;
            }
        };
    }
}

