/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.execution.dml.IntIndexer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.statistics.ColumnStatsSupport;
import io.crate.types.DataType;
import io.crate.types.EqQuery;
import io.crate.types.FixedWidthType;
import io.crate.types.IntEqQuery;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ByteType
extends DataType<Byte>
implements Streamer<Byte>,
FixedWidthType {
    public static final ByteType INSTANCE = new ByteType();
    public static final int ID = 2;
    public static final int PRECISION = 8;
    private static final StorageSupport<Number> STORAGE = new StorageSupport<Number>(true, true, (EqQuery)new IntEqQuery()){

        @Override
        public ValueIndexer<Number> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
            return new IntIndexer(ref);
        }

        @Override
        public Byte decode(int input) {
            return (byte)input;
        }
    };

    private ByteType() {
    }

    @Override
    public int id() {
        return 2;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.BYTE;
    }

    @Override
    public String getName() {
        return "byte";
    }

    @Override
    public Integer numericPrecision() {
        return 8;
    }

    @Override
    public Streamer<Byte> streamer() {
        return this;
    }

    @Override
    public Byte implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            Byte b = (Byte)value;
            return b;
        }
        if (value instanceof String) {
            String str = (String)value;
            return Byte.parseByte(str);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            try {
                return bigDecimal.byteValueExact();
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("byte value out of range: " + String.valueOf(value));
            }
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            int val = number.intValue();
            if (val < -128 || 127 < val) {
                throw new IllegalArgumentException("byte value out of range: " + val);
            }
            return (byte)val;
        }
        throw new ClassCastException("Can't cast '" + String.valueOf(value) + "' to " + this.getName());
    }

    @Override
    public Byte sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            Byte b = (Byte)value;
            return b;
        }
        return ((Number)value).byteValue();
    }

    @Override
    public int compare(Byte val1, Byte val2) {
        return Byte.compare(val1, val2);
    }

    @Override
    public Byte readValueFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? null : Byte.valueOf(in.readByte());
    }

    @Override
    public void writeValueTo(StreamOutput out, Byte v) throws IOException {
        out.writeBoolean(v == null);
        if (v != null) {
            out.writeByte(v);
        }
    }

    @Override
    public int fixedSize() {
        return 16;
    }

    @Override
    public long valueBytes(Byte value) {
        return 16L;
    }

    @Override
    public StorageSupport<Number> storageSupport() {
        return STORAGE;
    }

    @Override
    public ColumnStatsSupport<Byte> columnStatsSupport() {
        return ColumnStatsSupport.singleValued(Byte.class, this);
    }
}

