/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.execution.dml.FloatVectorIndexer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.expression.reference.doc.lucene.SourceParser;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.Expression;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.EqQuery;
import io.crate.types.StorageSupport;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class FloatVectorType
extends DataType<float[]>
implements Streamer<float[]> {
    public static final int ID = 28;
    public static final String NAME = "float_vector";
    public static final FloatVectorType INSTANCE_ONE = new FloatVectorType(1);
    public static final VectorSimilarityFunction SIMILARITY_FUNC = VectorSimilarityFunction.EUCLIDEAN;
    public static final int MAX_DIMENSIONS = 2048;
    private static final EqQuery<float[]> EQ_QUERY = new EqQuery<float[]>(){

        @Override
        public Query termQuery(String field, float[] value, boolean hasDocValues, boolean isIndexed) {
            return null;
        }

        @Override
        public Query rangeQuery(String field, float[] lowerTerm, float[] upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isIndexed) {
            return null;
        }

        @Override
        public Query termsQuery(String field, List<float[]> nonNullValues, boolean hasDocValues, boolean isIndexed) {
            return null;
        }
    };
    private static final StorageSupport<? super float[]> STORAGE_SUPPORT = new StorageSupport<float[]>(true, true, EQ_QUERY){

        @Override
        public ValueIndexer<? super float[]> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
            return new FloatVectorIndexer(ref);
        }

        @Override
        public float[] decode(ColumnIdent column, SourceParser sourceParser, Version tableVersion, byte[] bytes) {
            float[] floats = new float[bytes.length / 4];
            ByteBuffer.wrap(bytes).asFloatBuffer().get(floats);
            return floats;
        }
    };
    private final int dimensions;

    public FloatVectorType(int dimensions) {
        if (dimensions > 2048) {
            throw new IllegalArgumentException("Float vector type's length cannot exceed 2048");
        }
        this.dimensions = dimensions;
    }

    public FloatVectorType(StreamInput in) throws IOException {
        this.dimensions = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.dimensions);
    }

    @Override
    public int compare(float[] o1, float[] o2) {
        return Arrays.compare(o1, o2);
    }

    @Override
    public int id() {
        return 28;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.CUSTOM;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Streamer<float[]> streamer() {
        return this;
    }

    @Override
    public float[] sanitizeValue(Object obj) {
        if (obj instanceof List) {
            List values = (List)obj;
            float[] result = new float[values.size()];
            for (int i = 0; i < result.length; ++i) {
                Object value = values.get(i);
                if (value == null) {
                    throw new UnsupportedOperationException("null values are not allowed for float_vector");
                }
                result[i] = ((Number)value).floatValue();
            }
            return result;
        }
        return (float[])obj;
    }

    @Override
    public float[] implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        return this.sanitizeValue(value);
    }

    @Override
    public long valueBytes(float @Nullable [] value) {
        if (value == null) {
            return RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        }
        return RamUsageEstimator.sizeOf((float[])value);
    }

    @Override
    public TypeSignature getTypeSignature() {
        if (this.dimensions == 1) {
            return new TypeSignature(NAME);
        }
        return new TypeSignature(this.getName(), List.of(TypeSignature.of(this.dimensions)));
    }

    @Override
    public List<DataType<?>> getTypeParameters() {
        return List.of(DataTypes.INTEGER);
    }

    @Override
    public Integer characterMaximumLength() {
        return this.dimensions;
    }

    @Override
    public ColumnType<Expression> toColumnType(@Nullable Supplier<List<ColumnDefinition<Expression>>> convertChildColumn) {
        return new ColumnType(this.getName(), List.of(Integer.valueOf(this.dimensions)));
    }

    @Override
    public void addMappingOptions(Map<String, Object> mapping) {
        mapping.put("dimensions", this.dimensions);
    }

    @Override
    public float[] readValueFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            return in.readFloatArray();
        }
        return null;
    }

    @Override
    public void writeValueTo(StreamOutput out, float[] v) throws IOException {
        if (v == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeFloatArray(v);
        }
    }

    @Override
    public StorageSupport<? super float[]> storageSupport() {
        return STORAGE_SUPPORT;
    }
}

