/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.types.EqQuery;
import java.util.List;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.Query;

public class IntEqQuery
implements EqQuery<Number> {
    @Override
    public Query termQuery(String field, Number value, boolean hasDocValues, boolean isIndexed) {
        if (isIndexed) {
            return IntPoint.newExactQuery((String)field, (int)value.intValue());
        }
        if (hasDocValues) {
            return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)value.intValue());
        }
        return null;
    }

    @Override
    public Query rangeQuery(String field, Number lowerTerm, Number upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isIndexed) {
        int lower = Integer.MIN_VALUE;
        if (lowerTerm != null) {
            lower = includeLower ? lowerTerm.intValue() : lowerTerm.intValue() + 1;
        }
        int upper = Integer.MAX_VALUE;
        if (upperTerm != null) {
            int n = upper = includeUpper ? upperTerm.intValue() : upperTerm.intValue() - 1;
        }
        if (isIndexed) {
            return IntPoint.newRangeQuery((String)field, (int)lower, (int)upper);
        }
        if (hasDocValues) {
            return SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)lower, (long)upper);
        }
        return null;
    }

    @Override
    public Query termsQuery(String field, List<Number> nonNullValues, boolean hasDocValues, boolean isIndexed) {
        if (isIndexed) {
            return IntPoint.newSetQuery((String)field, (int[])nonNullValues.stream().mapToInt(Number::intValue).toArray());
        }
        if (hasDocValues) {
            return SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])nonNullValues.stream().mapToLong(Number::longValue).toArray());
        }
        return null;
    }
}

