/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.pgcatalog.OidHash;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class Regclass
implements Comparable<Regclass>,
Writeable {
    private final int oid;
    private final String name;

    public static Regclass relationOid(RelationInfo relation) {
        return new Regclass(OidHash.relationOid(OidHash.Type.fromRelationType(relation.relationType()), relation.ident()), relation.ident().fqn());
    }

    public static Regclass primaryOid(RelationInfo relation) {
        return new Regclass(OidHash.primaryKeyOid(relation.ident(), relation.primaryKey()), relation.ident().fqn());
    }

    public static Regclass fromRelationName(RelationName relationName) {
        return new Regclass(OidHash.relationOid(OidHash.Type.TABLE, relationName), relationName.fqn());
    }

    public Regclass(int oid, String name) {
        this.oid = oid;
        this.name = name;
    }

    public Regclass(StreamInput in) throws IOException {
        this.oid = in.readInt();
        this.name = in.readString();
    }

    public int oid() {
        return this.oid;
    }

    public String name() {
        return this.name;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.oid);
        out.writeString(this.name);
    }

    @Override
    public int compareTo(Regclass o) {
        return Integer.compare(this.oid, o.oid);
    }

    public String toString() {
        return Integer.toString(this.oid);
    }

    public int hashCode() {
        return this.oid;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Regclass other = (Regclass)obj;
        return this.oid == other.oid;
    }
}

