/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.common.StringUtils;
import io.crate.common.collections.Lists;
import io.crate.common.unit.TimeValue;
import io.crate.execution.dml.FulltextIndexer;
import io.crate.execution.dml.StringIndexer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.settings.SessionSettings;
import io.crate.sql.tree.BitString;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.Expression;
import io.crate.statistics.ColumnStatsSupport;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.EqQuery;
import io.crate.types.Regclass;
import io.crate.types.Regproc;
import io.crate.types.StorageSupport;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.jetbrains.annotations.Nullable;

public class StringType
extends DataType<String>
implements Streamer<String> {
    public static final int ID = 4;
    public static final StringType INSTANCE = new StringType();
    public static final String T = "t";
    public static final String F = "f";
    public static final int POSITION_INCREMENT_GAP = 100;
    private static final StorageSupport<Object> STORAGE = new StorageSupport<Object>(true, true, (EqQuery)new StringEqQuery(UnaryOperator.identity())){

        @Override
        public ValueIndexer<Object> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
            return switch (ref.indexType()) {
                default -> throw new MatchException(null, null);
                case IndexType.FULLTEXT -> new FulltextIndexer(ref);
                case IndexType.NONE, IndexType.PLAIN -> new StringIndexer(ref);
            };
        }
    };
    protected final int lengthLimit;

    public static StringType of(List<Integer> parameters) {
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("The text type can only have a single parameter value, received: " + parameters.size());
        }
        return StringType.of(parameters.get(0));
    }

    public static StringType of(int lengthLimit) {
        if (lengthLimit <= 0) {
            throw new IllegalArgumentException("The text type length must be at least 1, received: " + lengthLimit);
        }
        return new StringType(lengthLimit);
    }

    protected StringType(int lengthLimit) {
        this.lengthLimit = lengthLimit;
    }

    public StringType(StreamInput in) throws IOException {
        this.lengthLimit = in.getVersion().onOrAfter(Version.V_4_2_0) ? in.readInt() : Integer.MAX_VALUE;
    }

    protected StringType() {
        this(Integer.MAX_VALUE);
    }

    @Override
    public int id() {
        return 4;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.STRING;
    }

    @Override
    public String getName() {
        return "text";
    }

    public int lengthLimit() {
        return this.lengthLimit;
    }

    public boolean unbound() {
        return this.lengthLimit == Integer.MAX_VALUE;
    }

    @Override
    public TypeSignature getTypeSignature() {
        if (this.unbound()) {
            return super.getTypeSignature();
        }
        return new TypeSignature(this.getName(), List.of(TypeSignature.of(this.lengthLimit())));
    }

    @Override
    public List<DataType<?>> getTypeParameters() {
        if (this.unbound()) {
            return List.of();
        }
        return List.of(DataTypes.INTEGER);
    }

    @Override
    public Streamer<String> streamer() {
        return this;
    }

    @Override
    public String implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        return this.cast(value);
    }

    protected String cast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String str = (String)value;
            return str;
        }
        if (value instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)value;
            return bytesRef.utf8ToString();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? T : F;
        }
        if (value instanceof Map) {
            try {
                return Strings.toString(JsonXContent.builder().map((Map)value));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot cast `" + String.valueOf(value) + "` to type " + this.getName().toUpperCase(Locale.ENGLISH), e);
            }
        }
        if (value instanceof Collection) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot cast %s to type %s", value, this.getName().toUpperCase(Locale.ENGLISH)));
        }
        if (value.getClass().isArray()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot cast %s to type %s", Arrays.toString((Object[])value), this.getName().toUpperCase(Locale.ENGLISH)));
        }
        if (value instanceof TimeValue) {
            TimeValue timeValue = (TimeValue)value;
            return timeValue.getStringRep();
        }
        if (value instanceof Regproc) {
            Regproc regproc = (Regproc)value;
            return regproc.name();
        }
        if (value instanceof Regclass) {
            Regclass regclass = (Regclass)value;
            return regclass.name();
        }
        if (value instanceof BitString) {
            BitString bitString = (BitString)value;
            return bitString.asPrefixedBitString();
        }
        return value.toString();
    }

    @Override
    public String explicitCast(Object value, SessionSettings sessionSettings) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        String string = this.cast(value);
        if (this.unbound() || string.length() <= this.lengthLimit()) {
            return string;
        }
        return string.substring(0, this.lengthLimit());
    }

    @Override
    public String valueForInsert(String value) {
        if (value == null) {
            return null;
        }
        if (this.unbound() || ((String)value).length() <= this.lengthLimit) {
            return value;
        }
        if (StringUtils.isBlank((String)value, (int)this.lengthLimit, (int)((String)value).length())) {
            return ((String)value).substring(0, this.lengthLimit);
        }
        if (((String)value).length() > 20) {
            value = ((String)value).substring(0, 20) + "...";
        }
        throw new IllegalArgumentException("'" + (String)value + "' is too long for the text type of length: " + this.lengthLimit);
    }

    @Override
    public String sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)value;
            return bytesRef.utf8ToString();
        }
        return (String)value;
    }

    @Override
    public boolean isConvertableTo(DataType<?> other, boolean explicitCast) {
        if (explicitCast) {
            if (other instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)other;
                int innerTypeId = arrayType.innerType().id();
                return switch (innerTypeId) {
                    case 4 -> true;
                    case 26 -> true;
                    case 12 -> true;
                    default -> super.isConvertableTo(other, explicitCast);
                };
            }
            if (other.id() == 17) {
                return true;
            }
        }
        return super.isConvertableTo(other, explicitCast);
    }

    @Override
    public int compare(String val1, String val2) {
        return val1.compareTo(val2);
    }

    @Override
    public String readValueFrom(StreamInput in) throws IOException {
        return in.readOptionalString();
    }

    @Override
    public void writeValueTo(StreamOutput out, String v) throws IOException {
        out.writeOptionalString(v);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_4_2_0)) {
            out.writeInt(this.lengthLimit);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StringType that = (StringType)o;
        return this.lengthLimit() == that.lengthLimit();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lengthLimit());
    }

    @Override
    public ColumnType<Expression> toColumnType(@Nullable Supplier<List<ColumnDefinition<Expression>>> convertChildColumn) {
        if (this.unbound()) {
            return new ColumnType(this.getName());
        }
        return new ColumnType("varchar", List.of(Integer.valueOf(this.lengthLimit)));
    }

    @Override
    public StorageSupport<Object> storageSupport() {
        return STORAGE;
    }

    @Override
    public Integer characterMaximumLength() {
        if (this.unbound()) {
            return null;
        }
        return this.lengthLimit();
    }

    @Override
    public String toString() {
        if (this.unbound()) {
            return super.toString();
        }
        return "text(" + this.lengthLimit + ")";
    }

    @Override
    public long valueBytes(String value) {
        return RamUsageEstimator.sizeOf((String)value);
    }

    @Override
    public void addMappingOptions(Map<String, Object> mapping) {
        if (!this.unbound()) {
            mapping.put("length_limit", this.lengthLimit);
        }
    }

    @Override
    public ColumnStatsSupport<String> columnStatsSupport() {
        return ColumnStatsSupport.singleValued(String.class, this);
    }

    protected static final class StringEqQuery
    implements EqQuery<Object> {
        private final UnaryOperator<Object> preProcess;

        StringEqQuery(UnaryOperator<Object> preprocess) {
            this.preProcess = preprocess;
        }

        @Override
        public Query termQuery(String field, Object value, boolean hasDocValues, boolean isIndexed) {
            if (isIndexed) {
                return new TermQuery(new Term(field, BytesRefs.toBytesRef(this.preProcess.apply(value))));
            }
            if (hasDocValues) {
                return SortedSetDocValuesField.newSlowExactQuery((String)field, (BytesRef)BytesRefs.toBytesRef(this.preProcess.apply(value)));
            }
            return null;
        }

        @Override
        public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isIndexed) {
            if (isIndexed) {
                return new TermRangeQuery(field, BytesRefs.toBytesRef(this.preProcess.apply(lowerTerm)), BytesRefs.toBytesRef(this.preProcess.apply(upperTerm)), includeLower, includeUpper);
            }
            if (hasDocValues) {
                return SortedSetDocValuesField.newSlowRangeQuery((String)field, (BytesRef)BytesRefs.toBytesRef(this.preProcess.apply(lowerTerm)), (BytesRef)BytesRefs.toBytesRef(this.preProcess.apply(upperTerm)), (boolean)includeLower, (boolean)includeUpper);
            }
            return null;
        }

        @Override
        public Query termsQuery(String field, List<Object> nonNullValues, boolean hasDocValues, boolean isIndexed) {
            if (isIndexed) {
                return new TermInSetQuery(field, nonNullValues.stream().map(c -> BytesRefs.toBytesRef(this.preProcess.apply(c))).toList());
            }
            if (hasDocValues) {
                return SortedSetDocValuesField.newSlowSetQuery((String)field, (Collection)Lists.map(nonNullValues, c -> BytesRefs.toBytesRef(this.preProcess.apply(c))));
            }
            return null;
        }
    }
}

