/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import io.crate.common.CheckedFunction;
import io.crate.common.CheckedSupplier;
import io.crate.common.exceptions.Exceptions;
import io.crate.exceptions.SQLExceptions;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.CheckedRunnable;

public interface ActionListener<Response>
extends BiConsumer<Response, Throwable> {
    public void onResponse(Response var1);

    public void onFailure(Exception var1);

    @Override
    default public void accept(Response response, Throwable throwable) {
        if (throwable == null) {
            this.onResponse(response);
        } else {
            this.onFailure(Exceptions.toException((Throwable)SQLExceptions.unwrap(throwable)));
        }
    }

    default public <T, E extends Exception> ActionListener<T> map(final CheckedFunction<? super T, Response, E> fn) {
        final ActionListener delegate = this;
        return new ActionListener<T>(){

            @Override
            public void onResponse(T response) {
                try {
                    delegate.onResponse(fn.apply(response));
                }
                catch (Throwable t) {
                    delegate.onFailure(Exceptions.toException((Throwable)t));
                }
            }

            @Override
            public void onFailure(Exception e) {
                delegate.onFailure(e);
            }
        };
    }

    public static <Response> ActionListener<Response> wrap(final CheckedConsumer<Response, ? extends Exception> onResponse, final Consumer<Exception> onFailure) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    onResponse.accept(response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                onFailure.accept(e);
            }
        };
    }

    public static <T, R> ActionListener<T> delegateFailure(final ActionListener<R> delegate, final BiConsumer<ActionListener<R>, T> bc) {
        return new ActionListener<T>(){

            @Override
            public void onResponse(T r) {
                try {
                    bc.accept(delegate, r);
                }
                catch (Throwable t) {
                    delegate.onFailure(Exceptions.toException((Throwable)t));
                }
            }

            @Override
            public void onFailure(Exception e) {
                delegate.onFailure(e);
            }
        };
    }

    public static <Response> ActionListener<Response> wrap(Runnable runnable) {
        return ActionListener.wrap(r -> runnable.run(), e -> runnable.run());
    }

    public static <Response> void onResponse(Iterable<ActionListener<Response>> listeners, Response response) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onResponse(response);
            }
            catch (Exception ex) {
                try {
                    listener.onFailure(ex);
                }
                catch (Exception ex1) {
                    exceptionList.add(ex1);
                }
            }
        }
        SQLExceptions.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <Response> void onFailure(Iterable<ActionListener<Response>> listeners, Exception failure) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onFailure(failure);
            }
            catch (Exception ex) {
                exceptionList.add(ex);
            }
        }
        SQLExceptions.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <Response> ActionListener<Response> runAfter(final ActionListener<Response> delegate, final Runnable runAfter) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    delegate.onResponse(response);
                }
                finally {
                    runAfter.run();
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    delegate.onFailure(e);
                }
                finally {
                    runAfter.run();
                }
            }
        };
    }

    public static <Response> void completeWith(ActionListener<Response> listener, CheckedSupplier<Response, ? extends Exception> supplier) {
        try {
            listener.onResponse(supplier.get());
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public static <Response> ActionListener<Response> runBefore(final ActionListener<Response> delegate, final CheckedRunnable<?> runBefore) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    runBefore.run();
                }
                catch (Exception ex) {
                    delegate.onFailure(ex);
                    return;
                }
                delegate.onResponse(response);
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    runBefore.run();
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
                delegate.onFailure(e);
            }
        };
    }

    public static <T> ActionListener<T> delegateResponse(final ActionListener<T> delegate, final BiConsumer<ActionListener<T>, Exception> onFailure) {
        return new ActionListener<T>(){

            @Override
            public void onResponse(T r) {
                delegate.onResponse(r);
            }

            @Override
            public void onFailure(Exception e) {
                onFailure.accept(delegate, e);
            }
        };
    }
}

