/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.refresh;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.replication.BasicReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardRefreshAction
extends TransportReplicationAction<BasicReplicationRequest, BasicReplicationRequest, ReplicationResponse> {
    public static final String NAME = "indices:admin/refresh[s]";
    public static final ActionType<ReplicationResponse> TYPE = new ActionType("indices:admin/refresh[s]");

    @Inject
    public TransportShardRefreshAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction) {
        super(settings, NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, BasicReplicationRequest::new, BasicReplicationRequest::new, "refresh");
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(BasicReplicationRequest shardRequest, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<BasicReplicationRequest, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> {
            primary.refresh("api");
            this.logger.trace("{} refresh request executed on primary", (Object)primary.shardId());
            return new TransportReplicationAction.PrimaryResult<BasicReplicationRequest, ReplicationResponse>(shardRequest, new ReplicationResponse());
        });
    }

    @Override
    protected TransportReplicationAction.ReplicaResult shardOperationOnReplica(BasicReplicationRequest request, IndexShard replica) {
        replica.refresh("api");
        this.logger.trace("{} refresh request executed on replica", (Object)replica.shardId());
        return new TransportReplicationAction.ReplicaResult();
    }
}

