/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import io.crate.common.exceptions.Exceptions;
import io.crate.exceptions.SQLExceptions;
import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;

public class DefaultShardOperationFailedException
extends ShardOperationFailedException {
    public DefaultShardOperationFailedException(ElasticsearchException e) {
        super(e.getIndex() == null ? null : e.getIndex().getName(), e.getShardId() == null ? -1 : e.getShardId().id(), Exceptions.stackTrace((Throwable)e), e.status(), e);
    }

    public DefaultShardOperationFailedException(String index, int shardId, Throwable cause) {
        super(index, shardId, Exceptions.stackTrace((Throwable)cause), SQLExceptions.status(cause), cause);
    }

    public DefaultShardOperationFailedException(StreamInput in) throws IOException {
        this.index = in.readOptionalString();
        this.shardId = in.readVInt();
        this.cause = in.readException();
        this.status = RestStatus.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.index);
        out.writeVInt(this.shardId);
        out.writeException(this.cause);
        RestStatus.writeTo(out, this.status);
    }

    public String toString() {
        return "[" + this.index + "][" + this.shardId + "] failed, reason [" + this.reason() + "]";
    }
}

