/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class HandledTransportAction<Request extends TransportRequest, Response extends TransportResponse>
extends TransportAction<Request, Response> {
    protected final Logger logger = LogManager.getLogger(this.getClass());

    protected HandledTransportAction(String actionName, TransportService transportService, Writeable.Reader<Request> reader) {
        this(actionName, true, transportService, reader);
    }

    protected HandledTransportAction(String actionName, boolean canTripCircuitBreaker, TransportService transportService, Writeable.Reader<Request> requestReader) {
        super(actionName);
        transportService.registerRequestHandler(actionName, "same", false, canTripCircuitBreaker, requestReader, new TransportHandler());
    }

    class TransportHandler
    implements TransportRequestHandler<Request> {
        TransportHandler() {
        }

        @Override
        public final void messageReceived(Request request, TransportChannel channel) throws Exception {
            HandledTransportAction.this.execute(request).whenComplete((BiConsumer)new ChannelActionListener(channel, HandledTransportAction.this.actionName, request));
        }
    }
}

