/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import io.crate.action.FutureActionListener;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;

public abstract class TransportAction<Request extends TransportRequest, Response extends TransportResponse> {
    protected final String actionName;

    protected TransportAction(String actionName) {
        this.actionName = actionName;
    }

    public final CompletableFuture<Response> execute(Request request) {
        return this.execute(request, x -> x);
    }

    public final <T> CompletableFuture<T> execute(Request request, Function<? super Response, ? extends T> mapper) {
        FutureActionListener listener = new FutureActionListener();
        try {
            this.doExecute(request, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
        return listener.thenApply(mapper);
    }

    protected abstract void doExecute(Request var1, ActionListener<Response> var2);
}

