/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import io.crate.common.unit.TimeValue;
import io.crate.concurrent.CompletionListenable;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.AckedClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Priority;
import org.jetbrains.annotations.Nullable;

public abstract class AckedClusterStateUpdateTask<Response>
extends ClusterStateUpdateTask
implements AckedClusterStateTaskListener,
CompletionListenable<Response> {
    private final AckedRequest request;
    private final CompletableFuture<Response> future = new CompletableFuture();

    protected AckedClusterStateUpdateTask(AckedRequest request, ActionListener<Response> listener) {
        this(Priority.NORMAL, request);
        this.future.whenComplete((BiConsumer)listener);
    }

    protected AckedClusterStateUpdateTask(Priority priority, AckedRequest request, ActionListener<Response> listener) {
        this(priority, request);
        this.future.whenComplete((BiConsumer)listener);
    }

    protected AckedClusterStateUpdateTask(AckedRequest request) {
        this(Priority.NORMAL, request);
    }

    protected AckedClusterStateUpdateTask(Priority priority, AckedRequest request) {
        super(priority);
        this.request = request;
    }

    @Override
    public boolean mustAck(DiscoveryNode discoveryNode) {
        return true;
    }

    @Override
    public void onAllNodesAcked(@Nullable Exception e) {
        this.future.complete(this.newResponse(e == null));
    }

    protected abstract Response newResponse(boolean var1);

    @Override
    public void onAckTimeout() {
        this.future.complete(this.newResponse(false));
    }

    @Override
    public void onFailure(String source, Exception e) {
        this.future.completeExceptionally(e);
    }

    @Override
    public TimeValue ackTimeout() {
        return this.request.ackTimeout();
    }

    @Override
    public TimeValue timeout() {
        return this.request.masterNodeTimeout();
    }

    @Override
    public CompletableFuture<Response> completionFuture() {
        return this.future;
    }
}

