/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import io.crate.cluster.gracefulstop.DecommissionAllocationDecider;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.routing.DelayedAllocationService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.command.AllocateEmptyPrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocateReplicaAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocateStalePrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.CancelAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.MoveAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ClusterRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ConcurrentRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.MaxRetryAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.NodeVersionAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.RebalanceOnlyWhenActiveAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ReplicaAfterPrimaryActiveAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ResizeAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.RestoreInProgressAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.SameShardAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.SnapshotInProgressAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.snapshots.SnapshotsInfoService;

public class ClusterModule
extends AbstractModule {
    public static final String BALANCED_ALLOCATOR = "balanced";
    public static final Setting<String> SHARDS_ALLOCATOR_TYPE_SETTING = new Setting("cluster.routing.allocation.type", "balanced", Function.identity(), DataTypes.STRING, Setting.Property.NodeScope);
    private final ClusterService clusterService;
    private final AllocationDeciders allocationDeciders;
    private final AllocationService allocationService;
    private final List<ClusterPlugin> clusterPlugins;
    private final Collection<AllocationDecider> deciderList;
    private final ShardsAllocator shardsAllocator;
    static final Set<String> PRE_6_3_METADATA_CUSTOMS_WHITE_LIST = Set.of("index-graveyard", "repositories");
    static final Set<String> PRE_6_3_CLUSTER_CUSTOMS_WHITE_LIST = Set.of("restore", "snapshot_deletions", "snapshots");

    public ClusterModule(Settings settings, ClusterService clusterService, List<ClusterPlugin> clusterPlugins, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService) {
        this.clusterPlugins = clusterPlugins;
        this.deciderList = ClusterModule.createAllocationDeciders(settings, clusterService.getClusterSettings(), clusterPlugins);
        this.allocationDeciders = new AllocationDeciders(this.deciderList);
        this.shardsAllocator = ClusterModule.createShardsAllocator(settings, clusterService.getClusterSettings(), clusterPlugins);
        this.clusterService = clusterService;
        this.allocationService = new AllocationService(this.allocationDeciders, this.shardsAllocator, clusterInfoService, snapshotsInfoService);
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        ClusterModule.registerClusterCustom(entries, "snapshots", SnapshotsInProgress::new, SnapshotsInProgress::readDiffFrom);
        ClusterModule.registerClusterCustom(entries, "restore", RestoreInProgress::new, RestoreInProgress::readDiffFrom);
        ClusterModule.registerClusterCustom(entries, "snapshot_deletions", SnapshotDeletionsInProgress::new, SnapshotDeletionsInProgress::readDiffFrom);
        ClusterModule.registerMetadataCustom(entries, "repositories", RepositoriesMetadata::new, RepositoriesMetadata::readDiffFrom);
        ClusterModule.registerMetadataCustom(entries, "index-graveyard", IndexGraveyard::new, IndexGraveyard::readDiffFrom);
        entries.add(new NamedWriteableRegistry.Entry(AllocationCommand.class, CancelAllocationCommand.COMMAND_NAME_FIELD.getPreferredName(), CancelAllocationCommand::new));
        entries.add(new NamedWriteableRegistry.Entry(AllocationCommand.class, MoveAllocationCommand.COMMAND_NAME_FIELD.getPreferredName(), MoveAllocationCommand::new));
        entries.add(new NamedWriteableRegistry.Entry(AllocationCommand.class, AllocateReplicaAllocationCommand.COMMAND_NAME_FIELD.getPreferredName(), AllocateReplicaAllocationCommand::new));
        entries.add(new NamedWriteableRegistry.Entry(AllocationCommand.class, AllocateEmptyPrimaryAllocationCommand.COMMAND_NAME_FIELD.getPreferredName(), AllocateEmptyPrimaryAllocationCommand::new));
        entries.add(new NamedWriteableRegistry.Entry(AllocationCommand.class, AllocateStalePrimaryAllocationCommand.COMMAND_NAME_FIELD.getPreferredName(), AllocateStalePrimaryAllocationCommand::new));
        return entries;
    }

    public static ClusterState filterCustomsForPre63Clients(ClusterState clusterState) {
        ClusterState.Builder builder = ClusterState.builder(clusterState);
        clusterState.customs().keysIt().forEachRemaining(name -> {
            if (!PRE_6_3_CLUSTER_CUSTOMS_WHITE_LIST.contains(name)) {
                builder.removeCustom((String)name);
            }
        });
        Metadata.Builder metaBuilder = Metadata.builder(clusterState.metadata());
        clusterState.metadata().customs().keysIt().forEachRemaining(name -> {
            if (!PRE_6_3_METADATA_CUSTOMS_WHITE_LIST.contains(name)) {
                metaBuilder.removeCustom((String)name);
            }
        });
        return builder.metadata(metaBuilder).build();
    }

    public static List<NamedXContentRegistry.Entry> getNamedXWriteables() {
        return List.of(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("repositories", new String[0]), RepositoriesMetadata::fromXContent), new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("index-graveyard", new String[0]), IndexGraveyard::fromXContent), new NamedXContentRegistry.Entry(AllocationCommand.class, CancelAllocationCommand.COMMAND_NAME_FIELD, CancelAllocationCommand::fromXContent), new NamedXContentRegistry.Entry(AllocationCommand.class, MoveAllocationCommand.COMMAND_NAME_FIELD, MoveAllocationCommand::fromXContent), new NamedXContentRegistry.Entry(AllocationCommand.class, AllocateReplicaAllocationCommand.COMMAND_NAME_FIELD, AllocateReplicaAllocationCommand::fromXContent), new NamedXContentRegistry.Entry(AllocationCommand.class, AllocateEmptyPrimaryAllocationCommand.COMMAND_NAME_FIELD, AllocateEmptyPrimaryAllocationCommand::fromXContent), new NamedXContentRegistry.Entry(AllocationCommand.class, AllocateStalePrimaryAllocationCommand.COMMAND_NAME_FIELD, AllocateStalePrimaryAllocationCommand::fromXContent));
    }

    private static <T extends ClusterState.Custom> void registerClusterCustom(List<NamedWriteableRegistry.Entry> entries, String name, Writeable.Reader<? extends T> reader, Writeable.Reader<NamedDiff> diffReader) {
        ClusterModule.registerCustom(entries, ClusterState.Custom.class, name, reader, diffReader);
    }

    private static <T extends Metadata.Custom> void registerMetadataCustom(List<NamedWriteableRegistry.Entry> entries, String name, Writeable.Reader<? extends T> reader, Writeable.Reader<NamedDiff> diffReader) {
        ClusterModule.registerCustom(entries, Metadata.Custom.class, name, reader, diffReader);
    }

    private static <T extends NamedWriteable> void registerCustom(List<NamedWriteableRegistry.Entry> entries, Class<T> category, String name, Writeable.Reader<? extends T> reader, Writeable.Reader<NamedDiff> diffReader) {
        entries.add(new NamedWriteableRegistry.Entry(category, name, reader));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, name, diffReader));
    }

    public static Collection<AllocationDecider> createAllocationDeciders(Settings settings, ClusterSettings clusterSettings, List<ClusterPlugin> clusterPlugins) {
        LinkedHashMap<Class, AllocationDecider> deciders = new LinkedHashMap<Class, AllocationDecider>();
        ClusterModule.addAllocationDecider(deciders, new MaxRetryAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new ResizeAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new ReplicaAfterPrimaryActiveAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new RebalanceOnlyWhenActiveAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new ClusterRebalanceAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new ConcurrentRebalanceAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new EnableAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new NodeVersionAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new SnapshotInProgressAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new RestoreInProgressAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new FilterAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new SameShardAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new DiskThresholdDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new ThrottlingAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new ShardsLimitAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new AwarenessAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new DecommissionAllocationDecider(settings, clusterSettings));
        clusterPlugins.stream().flatMap(p -> p.createAllocationDeciders(settings, clusterSettings).stream()).forEach(d -> ClusterModule.addAllocationDecider(deciders, d));
        return deciders.values();
    }

    private static void addAllocationDecider(Map<Class, AllocationDecider> deciders, AllocationDecider decider) {
        if (deciders.put(decider.getClass(), decider) != null) {
            throw new IllegalArgumentException("Cannot specify allocation decider [" + decider.getClass().getName() + "] twice");
        }
    }

    private static ShardsAllocator createShardsAllocator(Settings settings, ClusterSettings clusterSettings, List<ClusterPlugin> clusterPlugins) {
        HashMap<String, Supplier<ShardsAllocator>> allocators = new HashMap<String, Supplier<ShardsAllocator>>();
        allocators.put(BALANCED_ALLOCATOR, () -> new BalancedShardsAllocator(settings, clusterSettings));
        for (ClusterPlugin plugin : clusterPlugins) {
            plugin.getShardsAllocators(settings, clusterSettings).forEach((k, v) -> {
                if (allocators.put((String)k, (Supplier<ShardsAllocator>)v) != null) {
                    throw new IllegalArgumentException("ShardsAllocator [" + k + "] already defined");
                }
            });
        }
        String allocatorName = SHARDS_ALLOCATOR_TYPE_SETTING.get(settings);
        Supplier allocatorSupplier = (Supplier)allocators.get(allocatorName);
        if (allocatorSupplier == null) {
            throw new IllegalArgumentException("Unknown ShardsAllocator [" + allocatorName + "]");
        }
        return Objects.requireNonNull((ShardsAllocator)allocatorSupplier.get(), "ShardsAllocator factory for [" + allocatorName + "] returned null");
    }

    public AllocationService getAllocationService() {
        return this.allocationService;
    }

    protected void configure() {
        this.bind(GatewayAllocator.class).asEagerSingleton();
        this.bind(AllocationService.class).toInstance((Object)this.allocationService);
        this.bind(ClusterService.class).toInstance((Object)this.clusterService);
        this.bind(NodeConnectionsService.class).asEagerSingleton();
        this.bind(MetadataDeleteIndexService.class).asEagerSingleton();
        this.bind(MetadataUpdateSettingsService.class).asEagerSingleton();
        this.bind(DelayedAllocationService.class).asEagerSingleton();
        this.bind(ShardStateAction.class).asEagerSingleton();
        this.bind(AllocationDeciders.class).toInstance((Object)this.allocationDeciders);
        this.bind(ShardsAllocator.class).toInstance((Object)this.shardsAllocator);
    }

    public void setExistingShardsAllocators(GatewayAllocator gatewayAllocator) {
        HashMap<String, ExistingShardsAllocator> existingShardsAllocators = new HashMap<String, ExistingShardsAllocator>();
        existingShardsAllocators.put("gateway_allocator", gatewayAllocator);
        for (ClusterPlugin clusterPlugin : this.clusterPlugins) {
            for (Map.Entry<String, ExistingShardsAllocator> existingShardsAllocatorEntry : clusterPlugin.getExistingShardsAllocators().entrySet()) {
                String allocatorName = existingShardsAllocatorEntry.getKey();
                if (existingShardsAllocators.put(allocatorName, existingShardsAllocatorEntry.getValue()) == null) continue;
                throw new IllegalArgumentException("ExistingShardsAllocator [" + allocatorName + "] from [" + clusterPlugin.getClass().getName() + "] was already defined");
            }
        }
        this.allocationService.setExistingShardsAllocators(existingShardsAllocators);
    }
}

