/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoryOperation;
import org.elasticsearch.snapshots.InFlightShardSnapshotStates;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotsService;
import org.jetbrains.annotations.Nullable;

public class SnapshotsInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final SnapshotsInProgress EMPTY = new SnapshotsInProgress(Collections.emptyList());
    private static final Version VERSION_IN_SNAPSHOT_VERSION = Version.V_5_1_0;
    public static final String TYPE = "snapshots";
    public static final String ABORTED_FAILURE_TEXT = "Snapshot was aborted by deletion";
    private final List<Entry> entries;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotsInProgress that = (SnapshotsInProgress)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SnapshotsInProgress[");
        for (int i = 0; i < this.entries.size(); ++i) {
            builder.append(this.entries.get(i).snapshot().getSnapshotId().getName());
            if (i + 1 >= this.entries.size()) continue;
            builder.append(",");
        }
        return builder.append("]").toString();
    }

    public static Entry startedEntry(Snapshot snapshot, boolean includeGlobalState, boolean partial, List<IndexId> indices, List<String> templates, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, Version version) {
        return new Entry(snapshot, includeGlobalState, partial, SnapshotsInProgress.completed(shards.values()) ? State.SUCCESS : State.STARTED, indices, templates, startTime, repositoryStateId, shards, null, version);
    }

    public static boolean completed(ObjectContainer<ShardSnapshotStatus> shards) {
        for (ObjectCursor status : shards) {
            if (((ShardSnapshotStatus)status.value).state().completed) continue;
            return false;
        }
        return true;
    }

    private static boolean assertConsistentEntries(List<Entry> entries) {
        HashMap<String, Set> assignedShardsByRepo = new HashMap<String, Set>();
        for (Entry entry : entries) {
            for (ObjectObjectCursor<ShardId, ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                if (((ShardSnapshotStatus)objectObjectCursor.value).isActive()) assert (assignedShardsByRepo.computeIfAbsent(entry.repository(), k -> new HashSet()).add((ShardId)objectObjectCursor.key)) : "Found duplicate shard assignments in " + String.valueOf(entries);
            }
        }
        for (String repoName : assignedShardsByRepo.keySet()) {
            InFlightShardSnapshotStates.forRepo(repoName, entries);
        }
        return true;
    }

    public static SnapshotsInProgress of(List<Entry> entries) {
        if (entries.isEmpty()) {
            return EMPTY;
        }
        return new SnapshotsInProgress(Collections.unmodifiableList(entries));
    }

    private SnapshotsInProgress(List<Entry> entries) {
        this.entries = entries;
        assert (SnapshotsInProgress.assertConsistentEntries(entries));
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public Entry snapshot(Snapshot snapshot) {
        for (Entry entry : this.entries) {
            Snapshot curr = entry.snapshot();
            if (!curr.equals(snapshot)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return SnapshotsInProgress.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    public SnapshotsInProgress(StreamInput in) throws IOException {
        this.entries = in.readList(Entry::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.entries);
    }

    public static class Entry
    implements Writeable,
    RepositoryOperation {
        private final State state;
        private final Snapshot snapshot;
        private final boolean includeGlobalState;
        private final boolean partial;
        private final ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards;
        private final List<IndexId> indices;
        private final List<String> templates;
        private final long startTime;
        private final long repositoryStateId;
        private final Version version;
        @Nullable
        private final String failure;

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, List<String> templates, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, String failure, Version version) {
            this.state = state;
            this.snapshot = snapshot;
            this.includeGlobalState = includeGlobalState;
            this.partial = partial;
            this.indices = indices;
            this.templates = templates;
            this.startTime = startTime;
            this.shards = shards;
            assert (Entry.assertShardsConsistent(state, indices, shards));
            this.repositoryStateId = repositoryStateId;
            this.failure = failure;
            this.version = version;
        }

        private Entry(StreamInput in) throws IOException {
            this.snapshot = new Snapshot(in);
            this.includeGlobalState = in.readBoolean();
            this.partial = in.readBoolean();
            this.state = State.fromValue(in.readByte());
            this.indices = in.readList(IndexId::new);
            this.templates = in.getVersion().after(Version.V_4_5_1) ? List.of(in.readStringArray()) : List.of();
            this.startTime = in.readLong();
            this.shards = in.readImmutableMap(ShardId::new, ShardSnapshotStatus::new);
            this.repositoryStateId = in.readLong();
            this.failure = in.readOptionalString();
            this.version = in.getVersion().onOrAfter(VERSION_IN_SNAPSHOT_VERSION) ? Version.readVersion(in) : (in.getVersion().onOrAfter(SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION) ? (in.readBoolean() ? SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION : SnapshotsService.OLD_SNAPSHOT_FORMAT) : SnapshotsService.OLD_SNAPSHOT_FORMAT);
        }

        private static boolean assertShardsConsistent(State state, List<IndexId> indices, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            if ((state == State.INIT || state == State.ABORTED) && shards.isEmpty()) {
                return true;
            }
            Set indexNames = indices.stream().map(IndexId::getName).collect(Collectors.toSet());
            HashSet indexNamesInShards = new HashSet();
            shards.keysIt().forEachRemaining(s -> indexNamesInShards.add(s.getIndexName()));
            assert (indexNames.equals(indexNamesInShards)) : "Indices in shards " + String.valueOf(indexNamesInShards) + " differ from expected indices " + String.valueOf(indexNames) + " for state [" + String.valueOf((Object)state) + "]";
            boolean shardsCompleted = SnapshotsInProgress.completed(shards.values());
            assert (state.completed() && shardsCompleted || !state.completed() && !shardsCompleted) : "Completed state must imply all shards completed but saw state [" + String.valueOf((Object)state) + "] and shards " + String.valueOf(shards);
            return true;
        }

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, List<String> templates, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, Version version) {
            this(snapshot, includeGlobalState, partial, state, indices, templates, startTime, repositoryStateId, shards, null, version);
        }

        public Entry(Entry entry, State state, List<IndexId> indices, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, Version version, String failure) {
            this(entry.snapshot, entry.includeGlobalState, entry.partial, state, indices, entry.templates, entry.startTime, repositoryStateId, shards, failure, version);
        }

        public Entry withRepoGen(long newRepoGen) {
            assert (newRepoGen > this.repositoryStateId) : "Updated repository generation [" + newRepoGen + "] must be higher than current generation [" + this.repositoryStateId + "]";
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, this.state, this.indices, this.templates, this.startTime, newRepoGen, this.shards, this.failure, this.version);
        }

        @Nullable
        public Entry abort() {
            ImmutableOpenMap.Builder<ShardId, ShardSnapshotStatus> shardsBuilder = ImmutableOpenMap.builder();
            boolean completed = true;
            boolean allQueued = true;
            for (ObjectObjectCursor<ShardId, ShardSnapshotStatus> objectObjectCursor : this.shards) {
                ShardSnapshotStatus status = (ShardSnapshotStatus)objectObjectCursor.value;
                allQueued &= status.state() == ShardState.QUEUED;
                if (!status.state().completed()) {
                    String nodeId;
                    status = new ShardSnapshotStatus(nodeId, (nodeId = status.nodeId()) == null ? ShardState.FAILED : ShardState.ABORTED, "aborted by snapshot deletion", status.generation());
                }
                completed &= status.state().completed();
                shardsBuilder.put((ShardId)objectObjectCursor.key, status);
            }
            if (allQueued) {
                return null;
            }
            return this.fail(shardsBuilder.build(), completed ? State.SUCCESS : State.ABORTED, SnapshotsInProgress.ABORTED_FAILURE_TEXT);
        }

        public Entry fail(ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, State state, String failure) {
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, state, this.indices, this.templates, this.startTime, this.repositoryStateId, shards, failure, this.version);
        }

        public Entry withShardStates(ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            if (SnapshotsInProgress.completed(shards.values())) {
                return new Entry(this.snapshot, this.includeGlobalState, this.partial, State.SUCCESS, this.indices, this.templates, this.startTime, this.repositoryStateId, shards, this.failure, this.version);
            }
            return this.withStartedShards(shards);
        }

        public Entry withStartedShards(ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            Entry updated = new Entry(this.snapshot, this.includeGlobalState, this.partial, this.state, this.indices, this.templates, this.startTime, this.repositoryStateId, shards, this.failure, this.version);
            assert (!updated.state().completed() && !SnapshotsInProgress.completed(updated.shards().values())) : "Only running snapshots allowed but saw [" + String.valueOf(updated) + "]";
            return updated;
        }

        @Override
        public String repository() {
            return this.snapshot.getRepository();
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards() {
            return this.shards;
        }

        public State state() {
            return this.state;
        }

        public List<IndexId> indices() {
            return this.indices;
        }

        public List<String> templates() {
            return this.templates;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public boolean partial() {
            return this.partial;
        }

        public long startTime() {
            return this.startTime;
        }

        @Override
        public long repositoryStateId() {
            return this.repositoryStateId;
        }

        public String failure() {
            return this.failure;
        }

        public Version version() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.includeGlobalState != entry.includeGlobalState) {
                return false;
            }
            if (this.partial != entry.partial) {
                return false;
            }
            if (this.startTime != entry.startTime) {
                return false;
            }
            if (!this.indices.equals(entry.indices)) {
                return false;
            }
            if (!this.shards.equals(entry.shards)) {
                return false;
            }
            if (!this.snapshot.equals(entry.snapshot)) {
                return false;
            }
            if (this.state != entry.state) {
                return false;
            }
            if (this.repositoryStateId != entry.repositoryStateId) {
                return false;
            }
            return this.version.equals(entry.version);
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + this.snapshot.hashCode();
            result = 31 * result + (this.includeGlobalState ? 1 : 0);
            result = 31 * result + (this.partial ? 1 : 0);
            result = 31 * result + this.shards.hashCode();
            result = 31 * result + this.indices.hashCode();
            result = 31 * result + Long.hashCode(this.startTime);
            result = 31 * result + Long.hashCode(this.repositoryStateId);
            result = 31 * result + this.version.hashCode();
            return result;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.snapshot.writeTo(out);
            out.writeBoolean(this.includeGlobalState);
            out.writeBoolean(this.partial);
            out.writeByte(this.state.value());
            out.writeList(this.indices);
            if (out.getVersion().after(Version.V_4_5_1)) {
                out.writeStringArray(this.templates.toArray(new String[0]));
            }
            out.writeLong(this.startTime);
            out.writeMap(this.shards);
            out.writeLong(this.repositoryStateId);
            out.writeOptionalString(this.failure);
            if (out.getVersion().onOrAfter(VERSION_IN_SNAPSHOT_VERSION)) {
                Version.writeVersion(this.version, out);
            } else if (out.getVersion().onOrAfter(SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION)) {
                out.writeBoolean(SnapshotsService.useShardGenerations(this.version));
            }
        }
    }

    public static enum State {
        INIT(0, false),
        STARTED(1, false),
        SUCCESS(2, true),
        FAILED(3, true),
        ABORTED(4, false);

        private final byte value;
        private final boolean completed;

        private State(byte value, boolean completed) {
            this.value = value;
            this.completed = completed;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this.completed;
        }

        public static State fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 1: {
                    return STARTED;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
            }
            throw new IllegalArgumentException("No snapshot state for value [" + value + "]");
        }
    }

    public static class ShardSnapshotStatus
    implements Writeable {
        public static final ShardSnapshotStatus UNASSIGNED_QUEUED = new ShardSnapshotStatus(null, ShardState.QUEUED, null);
        public static final ShardSnapshotStatus MISSING = new ShardSnapshotStatus(null, ShardState.MISSING, "missing index", null);
        private final ShardState state;
        @Nullable
        private final String nodeId;
        private final String reason;
        @Nullable
        private final String generation;

        public ShardSnapshotStatus(String nodeId, String generation) {
            this(nodeId, ShardState.INIT, generation);
        }

        public ShardSnapshotStatus(@Nullable String nodeId, ShardState state, @Nullable String generation) {
            this(nodeId, state, null, generation);
        }

        public ShardSnapshotStatus(@Nullable String nodeId, ShardState state, String reason, @Nullable String generation) {
            this.nodeId = nodeId;
            this.state = state;
            this.reason = reason;
            this.generation = generation;
            assert (this.assertConsistent());
        }

        private boolean assertConsistent() {
            assert (!this.state.failed() || this.reason != null);
            assert (this.state != ShardState.INIT && this.state != ShardState.WAITING || this.nodeId != null) : "Null node id for state [" + String.valueOf((Object)this.state) + "]";
            return true;
        }

        public ShardSnapshotStatus(StreamInput in) throws IOException {
            this.nodeId = in.readOptionalString();
            this.state = ShardState.fromValue(in.readByte());
            this.generation = SnapshotsService.useShardGenerations(in.getVersion()) ? in.readOptionalString() : null;
            this.reason = in.readOptionalString();
        }

        public ShardState state() {
            return this.state;
        }

        @Nullable
        public String nodeId() {
            return this.nodeId;
        }

        @Nullable
        public String generation() {
            return this.generation;
        }

        public String reason() {
            return this.reason;
        }

        public boolean isActive() {
            return this.state == ShardState.INIT || this.state == ShardState.ABORTED || this.state == ShardState.WAITING;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            if (SnapshotsService.useShardGenerations(out.getVersion())) {
                out.writeOptionalString(this.generation);
            }
            out.writeOptionalString(this.reason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardSnapshotStatus status = (ShardSnapshotStatus)o;
            return Objects.equals(this.nodeId, status.nodeId) && Objects.equals(this.reason, status.reason) && Objects.equals(this.generation, status.generation) && this.state == status.state;
        }

        public int hashCode() {
            int result = this.state != null ? this.state.hashCode() : 0;
            result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
            result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
            result = 31 * result + (this.generation != null ? this.generation.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ShardSnapshotStatus[state=" + String.valueOf((Object)this.state) + ", nodeId=" + this.nodeId + ", reason=" + this.reason + ", generation=" + this.generation + "]";
        }
    }

    public static enum ShardState {
        INIT(0, false, false),
        SUCCESS(2, true, false),
        FAILED(3, true, true),
        ABORTED(4, false, true),
        MISSING(5, true, true),
        WAITING(6, false, false),
        QUEUED(7, false, false);

        private final byte value;
        private final boolean completed;
        private final boolean failed;

        private ShardState(byte value, boolean completed, boolean failed) {
            this.value = value;
            this.completed = completed;
            this.failed = failed;
        }

        public boolean completed() {
            return this.completed;
        }

        public boolean failed() {
            return this.failed;
        }

        public static ShardState fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
                case 5: {
                    return MISSING;
                }
                case 6: {
                    return WAITING;
                }
                case 7: {
                    return QUEUED;
                }
            }
            throw new IllegalArgumentException("No shard snapshot state for value [" + value + "]");
        }
    }
}

