/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColumnPositionResolver<T> {
    private final Map<Integer, List<Column<T>>> columnsToReposition = new TreeMap(Comparator.naturalOrder());

    public void updatePositions(int startingColumnPosition) {
        for (List<Column<T>> o : this.columnsToReposition.values()) {
            Collections.sort(o);
            for (Column<T> column : o) {
                column.updatePosition(++startingColumnPosition);
            }
        }
    }

    public void addColumnToReposition(String name, @Nullable Integer columnOrdering, T column, BiConsumer<T, Integer> setPosition, int depth) {
        Column<T> c = new Column<T>(name, columnOrdering, setPosition, column);
        List<Column<T>> columnsPerDepths = this.columnsToReposition.get(depth);
        if (columnsPerDepths == null) {
            ArrayList<Column<T>> columns = new ArrayList<Column<T>>();
            columns.add(c);
            this.columnsToReposition.put(depth, columns);
        } else {
            columnsPerDepths.add(c);
        }
    }

    public int numberOfColumnsToReposition() {
        return this.columnsToReposition.size();
    }

    private record Column<T>(String name, Integer columnOrdering, BiConsumer<T, Integer> setPosition, T column) implements Comparable<Column<T>>
    {
        public void updatePosition(Integer position) {
            this.setPosition.accept(this.column, position);
        }

        @Override
        public int compareTo(@NotNull Column<T> o) {
            if (this.columnOrdering == null && o.columnOrdering == null) {
                return this.name.compareTo(o.name);
            }
            if (this.columnOrdering == null) {
                return 1;
            }
            if (o.columnOrdering == null) {
                return -1;
            }
            int comparison = o.columnOrdering.compareTo(this.columnOrdering);
            if (comparison != 0) {
                return comparison;
            }
            return this.name.compareTo(o.name);
        }
    }
}

