/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import io.crate.server.xcontent.XContentHelper;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentType;

public class MappingMetadata
extends AbstractDiffable<MappingMetadata> {
    private final CompressedXContent source;

    public MappingMetadata(CompressedXContent mapping) throws IOException {
        this.source = mapping;
    }

    public MappingMetadata(Map<String, Object> mapping) throws IOException {
        this.source = new CompressedXContent(mapping);
    }

    public CompressedXContent source() {
        return this.source;
    }

    public Map<String, Object> sourceAsMap() throws ElasticsearchParseException {
        Map mapping = XContentHelper.convertToMap(this.source.compressedReference(), true, XContentType.JSON).map();
        if (mapping.size() == 1 && mapping.containsKey("default")) {
            mapping = (Map)mapping.get("default");
        }
        return mapping;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_5_2_0)) {
            out.writeString("default");
        }
        this.source().writeTo(out);
        if (out.getVersion().before(Version.V_5_0_0)) {
            out.writeBoolean(false);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingMetadata that = (MappingMetadata)o;
        return this.source.equals(that.source);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public MappingMetadata(StreamInput in) throws IOException {
        if (in.getVersion().before(Version.V_5_2_0)) {
            in.readString();
        }
        this.source = CompressedXContent.readCompressedString(in);
        if (in.getVersion().before(Version.V_5_0_0)) {
            in.readBoolean();
        }
    }

    public static Diff<MappingMetadata> readDiffFrom(StreamInput in) throws IOException {
        return MappingMetadata.readDiffFrom(MappingMetadata::new, in);
    }
}

