/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.fdw.ForeignTablesMetadata;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.view.ViewsMetadata;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.Diffs;
import org.elasticsearch.cluster.NamedDiffable;
import org.elasticsearch.cluster.NamedDiffableValueSerializer;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedObjectNotFoundException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.rest.RestStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class Metadata
implements Iterable<IndexMetadata>,
Diffable<Metadata> {
    private static final Logger LOGGER = LogManager.getLogger(Metadata.class);
    public static long COLUMN_OID_UNASSIGNED = 0L;
    public static final String ALL = "_all";
    public static final String UNKNOWN_CLUSTER_UUID = "_na_";
    public static EnumSet<XContentContext> API_ONLY = EnumSet.of(XContentContext.API);
    public static EnumSet<XContentContext> API_AND_GATEWAY = EnumSet.of(XContentContext.API, XContentContext.GATEWAY);
    public static EnumSet<XContentContext> API_AND_SNAPSHOT = EnumSet.of(XContentContext.API, XContentContext.SNAPSHOT);
    public static EnumSet<XContentContext> ALL_CONTEXTS = EnumSet.allOf(XContentContext.class);
    public static final Setting<Boolean> SETTING_READ_ONLY_SETTING = Setting.boolSetting("cluster.blocks.read_only", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_BLOCK = new ClusterBlock(6, "cluster read-only (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final Setting<Boolean> SETTING_READ_ONLY_ALLOW_DELETE_SETTING = Setting.boolSetting("cluster.blocks.read_only_allow_delete", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK = new ClusterBlock(13, "cluster read-only / allow delete (api)", false, false, true, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final Metadata EMPTY_METADATA = Metadata.builder().build();
    public static final String CONTEXT_MODE_PARAM = "context_mode";
    public static final String CONTEXT_MODE_SNAPSHOT = XContentContext.SNAPSHOT.toString();
    public static final String CONTEXT_MODE_GATEWAY = XContentContext.GATEWAY.toString();
    public static final String GLOBAL_STATE_FILE_PREFIX = "global-";
    private static final NamedDiffableValueSerializer<Custom> CUSTOM_VALUE_SERIALIZER = new NamedDiffableValueSerializer<Custom>(Custom.class);
    private final String clusterUUID;
    private final boolean clusterUUIDCommitted;
    private final long version;
    private final long columnOID;
    private final CoordinationMetadata coordinationMetadata;
    private final Settings transientSettings;
    private final Settings persistentSettings;
    private final Settings settings;
    private final ImmutableOpenMap<String, IndexMetadata> indices;
    private final ImmutableOpenMap<String, IndexMetadata> indicesByUUID;
    private final ImmutableOpenMap<String, IndexTemplateMetadata> templates;
    private final ImmutableOpenMap<String, Custom> customs;
    private final transient int totalNumberOfShards;
    private final int totalOpenIndexShards;
    private final int numberOfShards;
    private final String[] allIndices;
    private final String[] allOpenIndices;
    private final String[] allClosedIndices;
    private final SortedMap<String, AliasOrIndex> aliasAndIndexLookup;
    public static final MetadataStateFormat<Metadata> FORMAT = Metadata.createMetadataStateFormat(false);
    public static final MetadataStateFormat<Metadata> FORMAT_PRESERVE_CUSTOMS = Metadata.createMetadataStateFormat(true);

    Metadata(String clusterUUID, boolean clusterUUIDCommitted, long version, long columnOID, CoordinationMetadata coordinationMetadata, Settings transientSettings, Settings persistentSettings, ImmutableOpenMap<String, IndexMetadata> indices, ImmutableOpenMap<String, IndexTemplateMetadata> templates, ImmutableOpenMap<String, Custom> customs, String[] allIndices, String[] allOpenIndices, String[] allClosedIndices, SortedMap<String, AliasOrIndex> aliasAndIndexLookup) {
        this.clusterUUID = clusterUUID;
        this.clusterUUIDCommitted = clusterUUIDCommitted;
        this.version = version;
        this.columnOID = columnOID;
        this.coordinationMetadata = coordinationMetadata;
        this.transientSettings = transientSettings;
        this.persistentSettings = persistentSettings;
        this.settings = Settings.builder().put(persistentSettings).put(transientSettings).build();
        this.indices = indices;
        this.customs = customs;
        this.templates = templates;
        int totalNumberOfShards = 0;
        int totalOpenIndexShards = 0;
        int numberOfShards = 0;
        for (ObjectCursor cursor : indices.values()) {
            totalNumberOfShards += ((IndexMetadata)cursor.value).getTotalNumberOfShards();
            numberOfShards += ((IndexMetadata)cursor.value).getNumberOfShards();
            if (!IndexMetadata.State.OPEN.equals((Object)((IndexMetadata)cursor.value).getState())) continue;
            totalOpenIndexShards += ((IndexMetadata)cursor.value).getTotalNumberOfShards();
        }
        this.totalNumberOfShards = totalNumberOfShards;
        this.totalOpenIndexShards = totalOpenIndexShards;
        this.numberOfShards = numberOfShards;
        this.allIndices = allIndices;
        this.allOpenIndices = allOpenIndices;
        this.allClosedIndices = allClosedIndices;
        this.aliasAndIndexLookup = aliasAndIndexLookup;
        this.indicesByUUID = this.buildIndicesByUUIDMap();
    }

    private ImmutableOpenMap<String, IndexMetadata> buildIndicesByUUIDMap() {
        ImmutableOpenMap.Builder<String, IndexMetadata> builder = ImmutableOpenMap.builder();
        for (ObjectCursor cursor : this.indices.values()) {
            IndexMetadata indexMetadata = (IndexMetadata)cursor.value;
            builder.put(indexMetadata.getIndexUUID(), indexMetadata);
        }
        return builder.build();
    }

    public long version() {
        return this.version;
    }

    public long columnOID() {
        return this.columnOID;
    }

    public String clusterUUID() {
        return this.clusterUUID;
    }

    public boolean clusterUUIDCommitted() {
        return this.clusterUUIDCommitted;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings transientSettings() {
        return this.transientSettings;
    }

    public Settings persistentSettings() {
        return this.persistentSettings;
    }

    public CoordinationMetadata coordinationMetadata() {
        return this.coordinationMetadata;
    }

    public boolean hasAlias(String alias) {
        AliasOrIndex aliasOrIndex = (AliasOrIndex)this.getAliasAndIndexLookup().get(alias);
        if (aliasOrIndex != null) {
            return aliasOrIndex.isAlias();
        }
        return false;
    }

    public SortedMap<String, AliasOrIndex> getAliasAndIndexLookup() {
        return this.aliasAndIndexLookup;
    }

    public String[] getConcreteAllIndices() {
        return this.allIndices;
    }

    public String[] getConcreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] getConcreteAllClosedIndices() {
        return this.allClosedIndices;
    }

    public boolean hasIndex(String index) {
        return this.indices.containsKey(index);
    }

    public boolean hasIndex(Index index) {
        return this.indicesByUUID.containsKey(index.getUUID());
    }

    public boolean hasConcreteIndex(String index) {
        return this.getAliasAndIndexLookup().containsKey(index);
    }

    @Nullable
    public IndexMetadata index(String indexName) {
        return this.indices.get(indexName);
    }

    @Nullable
    public IndexMetadata index(Index index) {
        return this.indicesByUUID.get(index.getUUID());
    }

    public boolean hasIndexMetadata(IndexMetadata indexMetadata) {
        return this.indices.get(indexMetadata.getIndex().getName()) == indexMetadata;
    }

    public IndexMetadata getIndexSafe(Index index) {
        IndexMetadata metadata = this.index(index);
        if (metadata != null) {
            return metadata;
        }
        throw new IndexNotFoundException(index);
    }

    public ImmutableOpenMap<String, IndexMetadata> indices() {
        return this.indices;
    }

    public ImmutableOpenMap<String, IndexTemplateMetadata> templates() {
        return this.templates;
    }

    public ImmutableOpenMap<String, Custom> customs() {
        return this.customs;
    }

    public IndexGraveyard indexGraveyard() {
        return (IndexGraveyard)this.custom("index-graveyard");
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public <T extends Custom> T custom(String type, T defaultValue) {
        return (T)this.customs.getOrDefault(type, defaultValue);
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalOpenIndexShards() {
        return this.totalOpenIndexShards;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    @Override
    public Iterator<IndexMetadata> iterator() {
        return this.indices.valuesIt();
    }

    public static boolean isGlobalStateEquals(Metadata metadata1, Metadata metadata2) {
        if (!metadata1.coordinationMetadata.equals(metadata2.coordinationMetadata)) {
            return false;
        }
        if (!metadata1.persistentSettings.equals(metadata2.persistentSettings)) {
            return false;
        }
        if (!metadata1.templates.equals(metadata2.templates())) {
            return false;
        }
        if (!metadata1.clusterUUID.equals(metadata2.clusterUUID)) {
            return false;
        }
        if (metadata1.clusterUUIDCommitted != metadata2.clusterUUIDCommitted) {
            return false;
        }
        if (metadata1.columnOID != metadata2.columnOID) {
            return false;
        }
        int customCount1 = 0;
        for (ObjectObjectCursor<String, Custom> objectObjectCursor : metadata1.customs) {
            if (!((Custom)objectObjectCursor.value).context().contains((Object)XContentContext.GATEWAY)) continue;
            if (!((Custom)objectObjectCursor.value).equals(metadata2.custom((String)objectObjectCursor.key))) {
                return false;
            }
            ++customCount1;
        }
        int customCount2 = 0;
        for (ObjectCursor cursor : metadata2.customs.values()) {
            if (!((Custom)cursor.value).context().contains((Object)XContentContext.GATEWAY)) continue;
            ++customCount2;
        }
        return customCount1 == customCount2;
    }

    @Override
    public Diff<Metadata> diff(Metadata previousState) {
        return new MetadataDiff(previousState, this);
    }

    public static Diff<Metadata> readDiffFrom(StreamInput in) throws IOException {
        return new MetadataDiff(in);
    }

    public static Metadata fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser, false);
    }

    public static Metadata readFrom(StreamInput in) throws IOException {
        int i;
        Builder builder = new Builder();
        builder.version = in.readLong();
        if (in.getVersion().onOrAfter(Version.V_5_5_0)) {
            builder.columnOID(in.readLong());
        } else {
            builder.columnOID(COLUMN_OID_UNASSIGNED);
        }
        builder.clusterUUID = in.readString();
        builder.clusterUUIDCommitted = in.readBoolean();
        builder.coordinationMetadata(new CoordinationMetadata(in));
        builder.transientSettings(Settings.readSettingsFromStream(in));
        builder.persistentSettings(Settings.readSettingsFromStream(in));
        int size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexMetadata.readFrom(in), false);
        }
        size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexTemplateMetadata.readFrom(in));
        }
        int customSize = in.readVInt();
        for (int i2 = 0; i2 < customSize; ++i2) {
            Custom customIndexMetadata = in.readNamedWriteable(Custom.class);
            builder.putCustom(customIndexMetadata.getWriteableName(), customIndexMetadata);
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        if (out.getVersion().onOrAfter(Version.V_5_5_0)) {
            out.writeLong(this.columnOID);
        }
        out.writeString(this.clusterUUID);
        out.writeBoolean(this.clusterUUIDCommitted);
        this.coordinationMetadata.writeTo(out);
        Settings.writeSettingsToStream(out, this.transientSettings);
        Settings.writeSettingsToStream(out, this.persistentSettings);
        out.writeVInt(this.indices.size());
        for (IndexMetadata indexMetadata : this) {
            indexMetadata.writeTo(out);
        }
        out.writeVInt(this.templates.size());
        for (ObjectCursor cursor : this.templates.values()) {
            ((IndexTemplateMetadata)cursor.value).writeTo(out);
        }
        int numberOfCustoms = 0;
        for (ObjectCursor cursor : this.customs.values()) {
            if (!VersionedNamedWriteable.shouldSerialize(out, (Custom)cursor.value)) continue;
            ++numberOfCustoms;
        }
        out.writeVInt(numberOfCustoms);
        for (ObjectCursor cursor : this.customs.values()) {
            if (!VersionedNamedWriteable.shouldSerialize(out, (Custom)cursor.value)) continue;
            out.writeNamedWriteable((NamedWriteable)cursor.value);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Metadata metadata) {
        return new Builder(metadata);
    }

    private static MetadataStateFormat<Metadata> createMetadataStateFormat(final boolean preserveUnknownCustoms) {
        return new MetadataStateFormat<Metadata>(GLOBAL_STATE_FILE_PREFIX){

            @Override
            public Metadata fromXContent(XContentParser parser) throws IOException {
                return Builder.fromXContent(parser, preserveUnknownCustoms);
            }

            @Override
            public Metadata readFrom(StreamInput in) throws IOException {
                return Metadata.readFrom(in);
            }
        };
    }

    public boolean contains(RelationName tableName) {
        if (this.indices.containsKey(tableName.indexNameOrAlias())) {
            return true;
        }
        if (this.templates.containsKey(PartitionName.templateName(tableName.schema(), tableName.name()))) {
            return true;
        }
        ViewsMetadata views = (ViewsMetadata)this.custom("views");
        if (views != null && views.contains(tableName)) {
            return true;
        }
        ForeignTablesMetadata foreignTables = this.custom("foreign_tables", ForeignTablesMetadata.EMPTY);
        return foreignTables.contains(tableName);
    }

    public static interface Custom
    extends NamedDiffable<Custom> {
        public EnumSet<XContentContext> context();
    }

    public static enum XContentContext {
        API,
        GATEWAY,
        SNAPSHOT;

    }

    private static class MetadataDiff
    implements Diff<Metadata> {
        private final long version;
        private final long columnOID;
        private final String clusterUUID;
        private final boolean clusterUUIDCommitted;
        private final CoordinationMetadata coordinationMetadata;
        private final Settings transientSettings;
        private final Settings persistentSettings;
        private final Diff<ImmutableOpenMap<String, IndexMetadata>> indices;
        private final Diff<ImmutableOpenMap<String, IndexTemplateMetadata>> templates;
        private final Diff<ImmutableOpenMap<String, Custom>> customs;
        private static final Diffs.DiffableValueReader<String, IndexMetadata> INDEX_METADATA_DIFF_VALUE_READER = new Diffs.DiffableValueReader(IndexMetadata::readFrom, IndexMetadata::readDiffFrom);
        private static final Diffs.DiffableValueReader<String, IndexTemplateMetadata> TEMPLATES_DIFF_VALUE_READER = new Diffs.DiffableValueReader(IndexTemplateMetadata::readFrom, IndexTemplateMetadata::readDiffFrom);

        MetadataDiff(Metadata before, Metadata after) {
            this.clusterUUID = after.clusterUUID;
            this.clusterUUIDCommitted = after.clusterUUIDCommitted;
            this.version = after.version;
            this.columnOID = after.columnOID;
            this.coordinationMetadata = after.coordinationMetadata;
            this.transientSettings = after.transientSettings;
            this.persistentSettings = after.persistentSettings;
            this.indices = Diffs.diff(before.indices, after.indices, Diffs.stringKeySerializer());
            this.templates = Diffs.diff(before.templates, after.templates, Diffs.stringKeySerializer());
            this.customs = Diffs.diff(before.customs, after.customs, Diffs.stringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
        }

        MetadataDiff(StreamInput in) throws IOException {
            this.clusterUUID = in.readString();
            this.clusterUUIDCommitted = in.readBoolean();
            this.version = in.readLong();
            this.columnOID = in.getVersion().onOrAfter(Version.V_5_5_0) ? in.readLong() : COLUMN_OID_UNASSIGNED;
            this.coordinationMetadata = new CoordinationMetadata(in);
            this.transientSettings = Settings.readSettingsFromStream(in);
            this.persistentSettings = Settings.readSettingsFromStream(in);
            this.indices = Diffs.readMapDiff(in, Diffs.stringKeySerializer(), INDEX_METADATA_DIFF_VALUE_READER);
            this.templates = Diffs.readMapDiff(in, Diffs.stringKeySerializer(), TEMPLATES_DIFF_VALUE_READER);
            this.customs = Diffs.readMapDiff(in, Diffs.stringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.clusterUUID);
            out.writeBoolean(this.clusterUUIDCommitted);
            out.writeLong(this.version);
            if (out.getVersion().onOrAfter(Version.V_5_5_0)) {
                out.writeLong(this.columnOID);
            }
            this.coordinationMetadata.writeTo(out);
            Settings.writeSettingsToStream(out, this.transientSettings);
            Settings.writeSettingsToStream(out, this.persistentSettings);
            this.indices.writeTo(out);
            this.templates.writeTo(out);
            this.customs.writeTo(out);
        }

        @Override
        public Metadata apply(Metadata part) {
            Builder builder = Metadata.builder();
            builder.clusterUUID(this.clusterUUID);
            builder.clusterUUIDCommitted(this.clusterUUIDCommitted);
            builder.version(this.version);
            builder.columnOID(this.columnOID);
            builder.coordinationMetadata(this.coordinationMetadata);
            builder.transientSettings(this.transientSettings);
            builder.persistentSettings(this.persistentSettings);
            builder.indices(this.indices.apply(part.indices));
            builder.templates(this.templates.apply(part.templates));
            builder.customs(this.customs.apply(part.customs));
            return builder.build();
        }
    }

    public static class Builder {
        private String clusterUUID;
        private boolean clusterUUIDCommitted;
        private long version;
        private ColumnOidSupplier columnOidSupplier;
        private CoordinationMetadata coordinationMetadata = CoordinationMetadata.EMPTY_METADATA;
        private Settings transientSettings = Settings.EMPTY;
        private Settings persistentSettings = Settings.EMPTY;
        private final ImmutableOpenMap.Builder<String, IndexMetadata> indices;
        private final ImmutableOpenMap.Builder<String, IndexTemplateMetadata> templates;
        private final ImmutableOpenMap.Builder<String, Custom> customs;

        public Builder() {
            this.clusterUUID = Metadata.UNKNOWN_CLUSTER_UUID;
            this.indices = ImmutableOpenMap.builder();
            this.templates = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
            this.columnOidSupplier = new ColumnOidSupplier(COLUMN_OID_UNASSIGNED);
            this.indexGraveyard(IndexGraveyard.builder().build());
        }

        public Builder(Metadata metadata) {
            this.clusterUUID = metadata.clusterUUID;
            this.clusterUUIDCommitted = metadata.clusterUUIDCommitted;
            this.coordinationMetadata = metadata.coordinationMetadata;
            this.transientSettings = metadata.transientSettings;
            this.persistentSettings = metadata.persistentSettings;
            this.version = metadata.version;
            this.columnOidSupplier = new ColumnOidSupplier(metadata.columnOID);
            this.indices = ImmutableOpenMap.builder(metadata.indices);
            this.templates = ImmutableOpenMap.builder(metadata.templates);
            this.customs = ImmutableOpenMap.builder(metadata.customs);
        }

        public Builder put(IndexMetadata.Builder indexMetadataBuilder) {
            indexMetadataBuilder.version(indexMetadataBuilder.version() + 1L);
            IndexMetadata indexMetadata = indexMetadataBuilder.build();
            this.indices.put(indexMetadata.getIndex().getName(), indexMetadata);
            return this;
        }

        public Builder put(IndexMetadata indexMetadata, boolean incrementVersion) {
            if (this.indices.get(indexMetadata.getIndex().getName()) == indexMetadata) {
                return this;
            }
            if (incrementVersion) {
                indexMetadata = IndexMetadata.builder(indexMetadata).version(indexMetadata.getVersion() + 1L).build();
            }
            this.indices.put(indexMetadata.getIndex().getName(), indexMetadata);
            return this;
        }

        public IndexMetadata get(String index) {
            return this.indices.get(index);
        }

        public IndexMetadata getSafe(Index index) {
            IndexMetadata indexMetadata = this.get(index.getName());
            if (indexMetadata != null) {
                if (indexMetadata.getIndexUUID().equals(index.getUUID())) {
                    return indexMetadata;
                }
                throw new IndexNotFoundException(index, (Throwable)new IllegalStateException("index uuid doesn't match expected: [" + index.getUUID() + "] but got: [" + indexMetadata.getIndexUUID() + "]"));
            }
            throw new IndexNotFoundException(index);
        }

        public Builder remove(String index) {
            this.indices.remove(index);
            return this;
        }

        public Builder removeAllIndices() {
            this.indices.clear();
            return this;
        }

        public Builder indices(ImmutableOpenMap<String, IndexMetadata> indices) {
            this.indices.putAll(indices);
            return this;
        }

        public Builder put(IndexTemplateMetadata.Builder template) {
            return this.put(template.build());
        }

        public Builder put(IndexTemplateMetadata template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public IndexTemplateMetadata getTemplate(String templateName) {
            return this.templates.get(templateName);
        }

        public Builder removeTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        public Builder templates(ImmutableOpenMap<String, IndexTemplateMetadata> templates) {
            this.templates.putAll(templates);
            return this;
        }

        public Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, custom);
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder customs(ImmutableOpenMap<String, Custom> customs) {
            this.customs.putAll(customs);
            return this;
        }

        public Builder indexGraveyard(IndexGraveyard indexGraveyard) {
            this.putCustom("index-graveyard", indexGraveyard);
            return this;
        }

        public IndexGraveyard indexGraveyard() {
            IndexGraveyard graveyard = (IndexGraveyard)this.getCustom("index-graveyard");
            return graveyard;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String[] indices) {
            for (String index : indices) {
                IndexMetadata indexMetadata = this.indices.get(index);
                if (indexMetadata == null) {
                    throw new IndexNotFoundException(index);
                }
                this.put(IndexMetadata.builder(indexMetadata).numberOfReplicas(numberOfReplicas));
            }
            return this;
        }

        public Builder coordinationMetadata(CoordinationMetadata coordinationMetadata) {
            this.coordinationMetadata = coordinationMetadata;
            return this;
        }

        public Settings transientSettings() {
            return this.transientSettings;
        }

        public Builder transientSettings(Settings settings) {
            this.transientSettings = settings;
            return this;
        }

        public Settings persistentSettings() {
            return this.persistentSettings;
        }

        public Builder persistentSettings(Settings settings) {
            this.persistentSettings = settings;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder columnOID(long columnOID) {
            this.columnOidSupplier = new ColumnOidSupplier(columnOID);
            return this;
        }

        public Builder clusterUUID(String clusterUUID) {
            this.clusterUUID = clusterUUID;
            return this;
        }

        public Builder clusterUUIDCommitted(boolean clusterUUIDCommitted) {
            this.clusterUUIDCommitted = clusterUUIDCommitted;
            return this;
        }

        public Builder generateClusterUuidIfNeeded() {
            if (this.clusterUUID.equals(Metadata.UNKNOWN_CLUSTER_UUID)) {
                this.clusterUUID = UUIDs.randomBase64UUID();
            }
            return this;
        }

        public ColumnOidSupplier columnOidSupplier() {
            return this.columnOidSupplier;
        }

        public Metadata build() {
            HashSet<String> allIndices = new HashSet<String>(this.indices.size());
            ArrayList<String> allOpenIndices = new ArrayList<String>();
            ArrayList<String> allClosedIndices = new ArrayList<String>();
            HashSet duplicateAliasesIndices = new HashSet();
            for (Object cursor : this.indices.values()) {
                IndexMetadata indexMetadata = (IndexMetadata)((ObjectCursor)cursor).value;
                String name = indexMetadata.getIndex().getName();
                boolean added = allIndices.add(name);
                assert (added) : "double index named [" + (String)name + "]";
                if (indexMetadata.getState() == IndexMetadata.State.OPEN) {
                    allOpenIndices.add(indexMetadata.getIndex().getName());
                } else if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                    allClosedIndices.add(indexMetadata.getIndex().getName());
                }
                indexMetadata.getAliases().keysIt().forEachRemaining(duplicateAliasesIndices::add);
            }
            duplicateAliasesIndices.retainAll(allIndices);
            if (!duplicateAliasesIndices.isEmpty()) {
                ArrayList<CallSite> duplicates = new ArrayList<CallSite>();
                for (ObjectCursor cursor : this.indices.values()) {
                    for (String alias : duplicateAliasesIndices) {
                        if (!((IndexMetadata)cursor.value).getAliases().containsKey(alias)) continue;
                        duplicates.add((CallSite)((Object)(alias + " (alias of " + String.valueOf(((IndexMetadata)cursor.value).getIndex()) + ")")));
                    }
                }
                assert (duplicates.size() > 0);
                throw new IllegalStateException("index and alias names need to be unique, but the following duplicates were found [" + String.join((CharSequence)", ", duplicates) + "]");
            }
            SortedMap<String, AliasOrIndex> aliasAndIndexLookup = Collections.unmodifiableSortedMap(this.buildAliasAndIndexLookup());
            String[] allIndicesArray = allIndices.toArray(new String[allIndices.size()]);
            String[] allOpenIndicesArray = allOpenIndices.toArray(new String[allOpenIndices.size()]);
            String[] allClosedIndicesArray = allClosedIndices.toArray(new String[allClosedIndices.size()]);
            return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, this.columnOidSupplier.columnOID, this.coordinationMetadata, this.transientSettings, this.persistentSettings, this.indices.build(), this.templates.build(), this.customs.build(), allIndicesArray, allOpenIndicesArray, allClosedIndicesArray, aliasAndIndexLookup);
        }

        private SortedMap<String, AliasOrIndex> buildAliasAndIndexLookup() {
            TreeMap<String, AliasOrIndex> aliasAndIndexLookup = new TreeMap<String, AliasOrIndex>();
            for (ObjectCursor cursor : this.indices.values()) {
                IndexMetadata indexMetadata = (IndexMetadata)cursor.value;
                AliasOrIndex existing = aliasAndIndexLookup.put(indexMetadata.getIndex().getName(), new AliasOrIndex.Index(indexMetadata));
                assert (existing == null) : "duplicate for " + String.valueOf(indexMetadata.getIndex());
                for (ObjectObjectCursor<String, AliasMetadata> aliasCursor : indexMetadata.getAliases()) {
                    AliasMetadata aliasMetadata = (AliasMetadata)aliasCursor.value;
                    aliasAndIndexLookup.compute(aliasMetadata.getAlias(), (aliasName, alias) -> {
                        if (alias == null) {
                            return new AliasOrIndex.Alias(aliasMetadata, indexMetadata);
                        }
                        assert (alias instanceof AliasOrIndex.Alias) : alias.getClass().getName();
                        ((AliasOrIndex.Alias)alias).addIndex(indexMetadata);
                        return alias;
                    });
                }
            }
            return aliasAndIndexLookup;
        }

        public static Metadata fromXContent(XContentParser parser, boolean preserveUnknownCustoms) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (!"meta-data".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    token = parser.nextToken();
                    if (token != XContentParser.Token.FIELD_NAME) {
                        throw new IllegalArgumentException("Expected a field name but got " + String.valueOf(token));
                    }
                    token = parser.nextToken();
                }
                currentFieldName = parser.currentName();
            }
            if (!"meta-data".equals(parser.currentName())) {
                throw new IllegalArgumentException("Expected [meta-data] as a field name but got " + currentFieldName);
            }
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("Expected a START_OBJECT but got " + String.valueOf(token));
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("cluster_coordination".equals(currentFieldName)) {
                        builder.coordinationMetadata(CoordinationMetadata.fromXContent(parser));
                        continue;
                    }
                    if ("settings".equals(currentFieldName)) {
                        builder.persistentSettings(Settings.fromXContent(parser));
                        continue;
                    }
                    if ("indices".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexMetadata.Builder.fromXContent(parser), false);
                        }
                        continue;
                    }
                    if ("templates".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexTemplateMetadata.Builder.fromXContent(parser, parser.currentName()));
                        }
                        continue;
                    }
                    try {
                        Custom custom = (Custom)parser.namedObject(Custom.class, currentFieldName, null);
                        builder.putCustom(custom.getWriteableName(), custom);
                    }
                    catch (NamedObjectNotFoundException ex) {
                        if (preserveUnknownCustoms) {
                            LOGGER.warn("Adding unknown custom object with type {}", (Object)currentFieldName);
                            builder.putCustom(currentFieldName, new UnknownGatewayOnlyCustom(parser.mapOrdered()));
                            continue;
                        }
                        LOGGER.warn("Skipping unknown custom object with type {}", (Object)currentFieldName);
                        parser.skipChildren();
                    }
                    continue;
                }
                if (token.isValue()) {
                    if ("version".equals(currentFieldName)) {
                        builder.version = parser.longValue();
                        continue;
                    }
                    if ("column_oid".equals(currentFieldName)) {
                        builder.columnOidSupplier = new ColumnOidSupplier(parser.longValue());
                        continue;
                    }
                    if ("cluster_uuid".equals(currentFieldName) || "uuid".equals(currentFieldName)) {
                        builder.clusterUUID = parser.text();
                        continue;
                    }
                    if ("cluster_uuid_committed".equals(currentFieldName)) {
                        builder.clusterUUIDCommitted = parser.booleanValue();
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                throw new IllegalArgumentException("Unexpected token " + String.valueOf(token));
            }
            return builder.build();
        }
    }

    public static class UnknownGatewayOnlyCustom
    implements Custom {
        private final Map<String, Object> contents;

        UnknownGatewayOnlyCustom(Map<String, Object> contents) {
            this.contents = contents;
        }

        @Override
        public EnumSet<XContentContext> context() {
            return EnumSet.of(XContentContext.API, XContentContext.GATEWAY);
        }

        @Override
        public Diff<Custom> diff(Custom previousState) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWriteableName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Version getMinimalSupportedVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class ColumnOidSupplier
    implements LongSupplier {
        private long columnOID;

        @VisibleForTesting
        public ColumnOidSupplier(long columnOID) {
            this.columnOID = columnOID;
        }

        @Override
        public long getAsLong() {
            ++this.columnOID;
            return this.columnOID;
        }
    }
}

