/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.elasticsearch.common.RandomBasedUUIDGenerator;
import org.elasticsearch.common.TimeBasedUUIDGenerator;
import org.elasticsearch.common.UUIDGenerator;

public class UUIDs {
    private static final RandomBasedUUIDGenerator RANDOM_UUID_GENERATOR = new RandomBasedUUIDGenerator();
    private static final UUIDGenerator TIME_UUID_GENERATOR = new TimeBasedUUIDGenerator();

    public static UUID dirtyUUID() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return new UUID(random.nextLong(), random.nextLong());
    }

    public static String base64UUID() {
        return TIME_UUID_GENERATOR.getBase64UUID();
    }

    public static String randomBase64UUID(Random random) {
        return RANDOM_UUID_GENERATOR.getBase64UUID(random);
    }

    public static String randomBase64UUID() {
        return RANDOM_UUID_GENERATOR.getBase64UUID();
    }
}

