/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.DeflateCompressor;
import org.elasticsearch.common.compress.NotCompressedException;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.xcontent.XContentType;
import org.jetbrains.annotations.Nullable;

public class CompressorFactory {
    public static final Compressor COMPRESSOR = new DeflateCompressor();

    @Nullable
    public static Compressor compressor(BytesReference bytes) {
        if (COMPRESSOR.isCompressed(bytes)) {
            assert (CompressorFactory.xContentType(bytes) == null);
            return COMPRESSOR;
        }
        XContentType contentType = CompressorFactory.xContentType(bytes);
        if (contentType == null) {
            if (CompressorFactory.isAncient(bytes)) {
                throw new IllegalStateException("unsupported compression: index was created before v2.0.0.beta1 and wasn't upgraded?");
            }
            throw new NotXContentException("Compressor detection can only be called on some xcontent bytes or compressed xcontent bytes");
        }
        return null;
    }

    private static XContentType xContentType(BytesReference bytesReference) {
        BytesRef br = bytesReference.toBytesRef();
        byte[] bytes = br.bytes;
        int offset = br.offset;
        int length = br.length;
        int totalLength = bytes.length;
        if (totalLength == 0 || length == 0) {
            return null;
        }
        if (offset + length > totalLength) {
            return null;
        }
        byte first = bytes[offset];
        if (first == 123) {
            return XContentType.JSON;
        }
        if (length > 2 && first == 58 && bytes[offset + 1] == 41 && bytes[offset + 2] == 10) {
            return XContentType.SMILE;
        }
        if (length > 2 && first == 45 && bytes[offset + 1] == 45 && bytes[offset + 2] == 45) {
            return XContentType.YAML;
        }
        int jsonStart = 0;
        if (length > 3 && first == -17 && bytes[offset + 1] == -69 && bytes[offset + 2] == -65) {
            jsonStart = 3;
        }
        for (int i = jsonStart; i < length; ++i) {
            byte b = bytes[offset + i];
            if (b == 123) {
                return XContentType.JSON;
            }
            if (!Character.isWhitespace(b)) break;
        }
        return null;
    }

    private static boolean isAncient(BytesReference bytes) {
        return bytes.length() >= 3 && bytes.get(0) == 90 && bytes.get(1) == 86 && (bytes.get(2) == 0 || bytes.get(2) == 1);
    }

    public static BytesReference uncompressIfNeeded(BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(Objects.requireNonNull(bytes, "the BytesReference must not be null"));
        return compressor == null ? bytes : compressor.uncompress(bytes);
    }

    public static BytesReference uncompress(BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor == null) {
            throw new NotCompressedException();
        }
        return compressor.uncompress(bytes);
    }
}

