/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.util.BitUtil;

public class MortonEncoder {
    private MortonEncoder() {
    }

    public static long encode(double latitude, double longitude) {
        GeoUtils.checkLatitude((double)latitude);
        GeoUtils.checkLongitude((double)longitude);
        int latEnc = GeoEncodingUtils.encodeLatitude((double)latitude) ^ Integer.MIN_VALUE;
        int lonEnc = GeoEncodingUtils.encodeLongitude((double)longitude) ^ Integer.MIN_VALUE;
        return BitUtil.interleave((int)lonEnc, (int)latEnc);
    }
}

