/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.apache.lucene.geo.Line;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.builders.LineStringBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class MultiLineStringBuilder
extends ShapeBuilder<JtsGeometry, MultiLineStringBuilder> {
    public static final GeoShapeType TYPE = GeoShapeType.MULTILINESTRING;
    private final ArrayList<LineStringBuilder> lines = new ArrayList();

    public MultiLineStringBuilder linestring(LineStringBuilder line) {
        this.lines.add(line);
        return this;
    }

    @Override
    public JtsGeometry buildS4J() {
        MultiLineString geometry;
        if (this.wrapdateline) {
            ArrayList<LineString> parts = new ArrayList<LineString>();
            for (LineStringBuilder line : this.lines) {
                LineStringBuilder.decomposeS4J(GEO_FACTORY, line.coordinates(false), parts);
            }
            if (parts.size() == 1) {
                geometry = (Geometry)parts.get(0);
            } else {
                LineString[] lineStrings = parts.toArray(new LineString[parts.size()]);
                geometry = GEO_FACTORY.createMultiLineString(lineStrings);
            }
        } else {
            LineString[] lineStrings = new LineString[this.lines.size()];
            Iterator<LineStringBuilder> iterator = this.lines.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                lineStrings[i] = GEO_FACTORY.createLineString(iterator.next().coordinates(false));
                ++i;
            }
            geometry = GEO_FACTORY.createMultiLineString(lineStrings);
        }
        return this.jtsGeometry((Geometry)geometry);
    }

    @Override
    public Object buildLucene() {
        if (this.wrapdateline) {
            ArrayList<Line> parts = new ArrayList<Line>();
            for (LineStringBuilder line : this.lines) {
                LineStringBuilder.decomposeLucene(line.coordinates(false), parts);
            }
            if (parts.size() == 1) {
                return parts.get(0);
            }
            return parts.toArray(new Line[parts.size()]);
        }
        Line[] linestrings = new Line[this.lines.size()];
        for (int i = 0; i < this.lines.size(); ++i) {
            LineStringBuilder lsb = this.lines.get(i);
            linestrings[i] = new Line(lsb.coordinates.stream().mapToDouble(c -> c.y).toArray(), lsb.coordinates.stream().mapToDouble(c -> c.x).toArray());
        }
        return linestrings;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.lines);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MultiLineStringBuilder other = (MultiLineStringBuilder)obj;
        return Objects.equals(this.lines, other.lines);
    }
}

