/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Assertions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;
import org.locationtech.spatial4j.shape.jts.JtsShapeFactory;

public abstract class ShapeBuilder<T extends Shape, E extends ShapeBuilder<T, E>> {
    protected static final Logger LOGGER = LogManager.getLogger(ShapeBuilder.class);
    private static final boolean DEBUG = Assertions.ENABLED;
    protected final List<Coordinate> coordinates;
    public static final double DATELINE = 180.0;
    public static final Coordinate ZERO_ZERO = new Coordinate(0.0, 0.0);
    public static final JtsSpatialContext SPATIAL_CONTEXT = JtsSpatialContext.GEO;
    public static final JtsShapeFactory SHAPE_FACTORY = SPATIAL_CONTEXT.getShapeFactory();
    public static final GeometryFactory GEO_FACTORY = SHAPE_FACTORY.getGeometryFactory();
    protected final boolean wrapdateline = SPATIAL_CONTEXT.isGeo();
    protected static final boolean MULTI_POLYGON_MAY_OVERLAP = false;
    protected static final boolean AUTO_VALIDATE_JTS_GEOMETRY = true;
    protected static final boolean AUTO_INDEX_JTS_GEOMETRY = true;
    protected static final IntersectionOrder INTERSECTION_ORDER = new IntersectionOrder();

    protected ShapeBuilder() {
        this.coordinates = new ArrayList<Coordinate>();
    }

    protected ShapeBuilder(List<Coordinate> coordinates) {
        if (coordinates == null || coordinates.size() == 0) {
            throw new IllegalArgumentException("cannot create point collection with empty set of points");
        }
        this.coordinates = coordinates;
    }

    protected Coordinate[] coordinates(boolean closed) {
        Coordinate[] result = this.coordinates.toArray(new Coordinate[this.coordinates.size() + (closed ? 1 : 0)]);
        if (closed) {
            result[result.length - 1] = result[0];
        }
        return result;
    }

    protected JtsGeometry jtsGeometry(Geometry geom) {
        JtsGeometry jtsGeometry = new JtsGeometry(geom, SPATIAL_CONTEXT, false, false);
        jtsGeometry.validate();
        jtsGeometry.index();
        return jtsGeometry;
    }

    public abstract T buildS4J();

    public abstract Object buildLucene();

    protected static Coordinate shift(Coordinate coordinate, double dateline) {
        if (dateline == 0.0) {
            return coordinate;
        }
        return new Coordinate(-2.0 * dateline + coordinate.x, coordinate.y);
    }

    protected static final double intersection(Coordinate p1, Coordinate p2, double dateline) {
        if (p1.x == p2.x && p1.x != dateline) {
            return Double.NaN;
        }
        if (p1.x == p2.x && p1.x == dateline) {
            return 1.0;
        }
        double t = (dateline - p1.x) / (p2.x - p1.x);
        if (t > 1.0 || t <= 0.0) {
            return Double.NaN;
        }
        return t;
    }

    protected static int intersections(double dateline, Edge[] edges) {
        int numIntersections = 0;
        assert (!Double.isNaN(dateline));
        for (int i = 0; i < edges.length; ++i) {
            Coordinate p1 = edges[i].coordinate;
            Coordinate p2 = edges[i].next.coordinate;
            assert (!Double.isNaN(p2.x) && !Double.isNaN(p1.x));
            edges[i].intersect = Edge.MAX_COORDINATE;
            double position = ShapeBuilder.intersection(p1, p2, dateline);
            if (Double.isNaN(position)) continue;
            edges[i].intersection(position);
            ++numIntersections;
        }
        Arrays.sort(edges, INTERSECTION_ORDER);
        return numIntersections;
    }

    protected static final boolean debugEnabled() {
        return LOGGER.isDebugEnabled() || DEBUG;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShapeBuilder)) {
            return false;
        }
        ShapeBuilder that = (ShapeBuilder)o;
        return Objects.equals(this.coordinates, that.coordinates);
    }

    public int hashCode() {
        return Objects.hash(this.coordinates);
    }

    protected static final class Edge {
        Coordinate coordinate;
        Edge next;
        Coordinate intersect;
        int component = -1;
        public static final Coordinate MAX_COORDINATE = new Coordinate(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

        protected Edge(Coordinate coordinate, Edge next, Coordinate intersection) {
            this.coordinate = coordinate;
            this.setNext(next);
            this.intersect = intersection;
            if (next != null) {
                this.component = next.component;
            }
        }

        protected Edge(Coordinate coordinate, Edge next) {
            this(coordinate, next, MAX_COORDINATE);
        }

        protected void setNext(Edge next) {
            if (next != null) {
                if (this.coordinate.equals((Object)next.coordinate)) {
                    throw new InvalidShapeException("Provided shape has duplicate consecutive coordinates at: " + String.valueOf(this.coordinate));
                }
                this.next = next;
            }
        }

        protected Coordinate intersection(double position) {
            this.intersect = Edge.position(this.coordinate, this.next.coordinate, position);
            return this.intersect;
        }

        protected static Coordinate position(Coordinate p1, Coordinate p2, double position) {
            if (position == 0.0) {
                return p1;
            }
            if (position == 1.0) {
                return p2;
            }
            double x = p1.x + position * (p2.x - p1.x);
            double y = p1.y + position * (p2.y - p1.y);
            return new Coordinate(x, y);
        }

        public String toString() {
            return "Edge[Component=" + this.component + "; start=" + String.valueOf(this.coordinate) + " ; intersection=" + String.valueOf(this.intersect) + "]";
        }
    }

    private static final class IntersectionOrder
    implements Comparator<Edge> {
        private IntersectionOrder() {
        }

        @Override
        public int compare(Edge o1, Edge o2) {
            return Double.compare(o1.intersect.y, o2.intersect.y);
        }
    }

    public static enum Orientation {
        LEFT,
        RIGHT;

        public static final Orientation CLOCKWISE;
        public static final Orientation COUNTER_CLOCKWISE;
        public static final Orientation CW;
        public static final Orientation CCW;

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this == RIGHT);
        }

        public static Orientation readFrom(StreamInput in) throws IOException {
            return in.readBoolean() ? RIGHT : LEFT;
        }

        public static Orientation fromString(String orientation) {
            switch (orientation = orientation.toLowerCase(Locale.ROOT)) {
                case "right": 
                case "counterclockwise": 
                case "ccw": {
                    return RIGHT;
                }
                case "left": 
                case "clockwise": 
                case "cw": {
                    return LEFT;
                }
            }
            throw new IllegalArgumentException("Unknown orientation [" + orientation + "]");
        }

        static {
            CLOCKWISE = LEFT;
            COUNTER_CLOCKWISE = RIGHT;
            CW = LEFT;
            CCW = RIGHT;
        }
    }
}

