/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lease;

import io.crate.common.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.common.lease.Releasable;
import org.jetbrains.annotations.Nullable;

public final class Releasables
extends Enum<Releasables> {
    private static final /* synthetic */ Releasables[] $VALUES;

    public static Releasables[] values() {
        return (Releasables[])$VALUES.clone();
    }

    public static Releasables valueOf(String name) {
        return Enum.valueOf(Releasables.class, name);
    }

    private static void close(Iterable<? extends Releasable> releasables, boolean ignoreException) {
        block2: {
            try {
                IOUtils.close(releasables);
            }
            catch (IOException e) {
                if (ignoreException) break block2;
                throw new UncheckedIOException(e);
            }
        }
    }

    public static void close(Iterable<? extends Releasable> releasables) {
        Releasables.close(releasables, false);
    }

    public static void close(@Nullable Releasable releasable) {
        try {
            IOUtils.close((Closeable[])new Closeable[]{releasable});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void close(Releasable ... releasables) {
        Releasables.close(Arrays.asList(releasables), false);
    }

    public static void closeIgnoringException(Iterable<? extends Releasable> releasables) {
        Releasables.close(releasables, true);
    }

    public static void closeIgnoringException(Releasable ... releasables) {
        Releasables.close(Arrays.asList(releasables), true);
    }

    public static Releasable wrap(Iterable<Releasable> releasables) {
        return () -> Releasables.close(releasables);
    }

    public static Releasable wrap(Releasable ... releasables) {
        return () -> Releasables.close(releasables);
    }

    public static Releasable releaseOnce(Releasable ... releasables) {
        AtomicBoolean released = new AtomicBoolean(false);
        return () -> {
            if (released.compareAndSet(false, true)) {
                Releasables.close(releasables);
            }
        };
    }

    private static /* synthetic */ Releasables[] $values() {
        return new Releasables[0];
    }

    static {
        $VALUES = Releasables.$values();
    }
}

